/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jsptest.JspTestCase;
import net.sf.jsptest.assertion.ElementAssertion;
import net.sf.jsptest.assertion.ElementChooser;
import net.sf.jsptest.assertion.FormAssertion;
import net.sf.jsptest.assertion.NameChooser;
import net.sf.jsptest.assertion.PageAssertion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.tidy.Tidy;

public abstract class HtmlTestCase
extends JspTestCase {
    private Document renderedDocument;
    private String renderedDocumentPath;
    private Tidy tidy;
    private DocumentBuilder documentBuilder;

    protected void request(String path, String httpMethod) throws Exception {
        super.request(path, httpMethod);
        this.parseRenderedHtml();
    }

    protected Document getRenderedHtml() {
        return this.renderedDocument;
    }

    protected String getRenderedHtmlPath() {
        return this.renderedDocumentPath;
    }

    private void parseRenderedHtml() {
        File original = this.getRenderedResponse();
        File tidyHtml = new File(original.getAbsolutePath() + ".tidy.html");
        this.parseRenderedOutput(original, tidyHtml);
    }

    private void parseRenderedOutput(File html, File prettyPrinted) {
        try {
            this.configureTidy().parse((InputStream)new FileInputStream(html), (OutputStream)new FileOutputStream(prettyPrinted));
            DocumentBuilder db = this.configureDocumentBuilder();
            this.renderedDocument = db.parse(prettyPrinted);
            this.renderedDocumentPath = prettyPrinted.getAbsolutePath();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage() + " (" + html.getAbsolutePath() + ")", e);
        }
    }

    private synchronized DocumentBuilder configureDocumentBuilder() throws ParserConfigurationException {
        if (this.documentBuilder == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.documentBuilder = dbf.newDocumentBuilder();
        }
        return this.documentBuilder;
    }

    private synchronized Tidy configureTidy() {
        if (this.tidy == null) {
            this.tidy = new Tidy();
            this.tidy.setMakeClean(true);
            this.tidy.setXmlOut(true);
            this.tidy.setTidyMark(false);
            this.tidy.setQuiet(true);
            this.tidy.setShowWarnings(false);
            this.tidy.setUpperCaseTags(true);
            this.tidy.setUpperCaseAttrs(true);
        }
        return this.tidy;
    }

    public FormAssertion form(String name) {
        return new FormAssertion(this.getRenderedHtml(), new NameChooser(name));
    }

    public FormAssertion form() {
        return new FormAssertion(this.getRenderedHtml(), new ElementChooser(){

            public boolean accept(Element element) {
                return true;
            }
        });
    }

    public PageAssertion page() {
        return new PageAssertion(this.getRenderedHtml());
    }

    public ElementAssertion element(String xpathExpression) {
        return new ElementAssertion(this.getRenderedHtml(), xpathExpression);
    }
}

