/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is.inspection;

import com.gc.iotools.stream.utils.LogUtils;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticInputStream<T extends InputStream>
extends FilterInputStream {
    private static int defaultLogDepth = 2;
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagnosticInputStream.class);
    private static final Collection<String> STATIC_WARNINGS = new ArrayList<String>();
    private int closeCount = 0;
    private String closeTrace;
    private final String constructorTrace;
    private final int logDepth;
    private boolean methodCalledAfterClose = false;
    private final Collection<String> warnings = new ArrayList<String>();

    public static String[] getFinalizationErrors() {
        return STATIC_WARNINGS.toArray(new String[STATIC_WARNINGS.size()]);
    }

    public static void resetFinalizationErrors() {
        STATIC_WARNINGS.clear();
    }

    public static void setDefaultLogDepth(int defaultFrameDepth) {
        defaultLogDepth = defaultFrameDepth;
    }

    public DiagnosticInputStream(T in) {
        this(in, defaultLogDepth);
    }

    public DiagnosticInputStream(T inputStream, int logDepth) {
        super((InputStream)inputStream);
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream passed in the constructor is null");
        }
        if (logDepth <= 0) {
            throw new IllegalArgumentException("Required logDepth is [" + logDepth + "] but it must be >0");
        }
        this.logDepth = logDepth;
        this.constructorTrace = LogUtils.getCaller(this.getClass(), logDepth);
    }

    @Override
    public int available() throws IOException {
        this.checkCloseInvoked("available");
        return super.available();
    }

    public void clearInstanceWarnings() {
        this.warnings.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.closeCount == 0) {
            this.closeTrace = LogUtils.getCaller(DiagnosticInputStream.class, this.logDepth);
        } else {
            String warning = "MULTIPLE_CLOSE : method " + this.getClass().getSimpleName() + ".close() is being called the[" + this.closeCount + "]time by [" + LogUtils.getCaller(DiagnosticInputStream.class, this.logDepth) + "]";
            LOGGER.warn(warning + " but stream was already closed by [" + this.closeTrace + "]");
            this.warnings.add(warning);
        }
        ++this.closeCount;
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        if (this.closeCount == 0) {
            String msg = "NOT_CLOSED : Finalizing [" + this.getClass().getSimpleName() + "] but close was not called yet. Wrapping class[" + this.in.getClass().getSimpleName() + "]";
            this.warnings.add(msg);
            LOGGER.warn(msg + " Constructor trace:" + this.constructorTrace);
        }
        try {
            super.finalize();
        }
        finally {
            if (this.warnings.size() > 0) {
                String statusString = this.getStatusMessage();
                LOGGER.warn(statusString);
                String methodName = this.getConstructorCallerMethod();
                STATIC_WARNINGS.add(methodName + " : " + statusString);
            }
        }
    }

    public int getCloseCount() {
        return this.closeCount;
    }

    public String[] getInstanceWarnings() {
        return this.warnings.toArray(new String[this.warnings.size()]);
    }

    public T getWrappedInputStream() {
        InputStream result = this.in;
        return (T)result;
    }

    public String getStatusMessage() {
        String result = null;
        if (this.warnings.size() > 0) {
            StringBuffer resultb = new StringBuffer(this.getClass().getSimpleName());
            resultb.append(" constructed by [" + this.constructorTrace + "] ");
            if (this.closeCount > 0) {
                resultb.append("closed by: [" + this.closeTrace + "] has warnings:");
            }
            boolean first = true;
            for (String warning : this.warnings) {
                resultb.append(warning);
                resultb.append(first ? "" : "-----------");
                first = false;
            }
            result = resultb.toString();
        }
        return result;
    }

    public boolean isMethodCalledAfterClose() {
        return this.methodCalledAfterClose;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.checkCloseInvoked("mark");
        super.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        this.checkCloseInvoked("markSupported");
        return super.markSupported();
    }

    @Override
    public int read() throws IOException {
        this.checkCloseInvoked("read()");
        return super.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkCloseInvoked("read(byte[])");
        return super.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkCloseInvoked("read(byte[],int,int)");
        return super.read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkCloseInvoked("reset");
        super.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkCloseInvoked("skip");
        return super.skip(n);
    }

    private void checkCloseInvoked(String methodName) {
        if (this.closeCount > 0) {
            this.methodCalledAfterClose = true;
            String warning = "ALREADY_CLOSED: [" + methodName + "] called by [" + LogUtils.getCaller(DiagnosticInputStream.class, this.logDepth) + "]";
            this.warnings.add(warning);
            LOGGER.warn(warning + "but the stream was already closed by [" + this.closeTrace + "]");
        }
    }

    private String getConstructorCallerMethod() {
        return this.constructorTrace.substring(this.constructorTrace.indexOf(46) + 1, this.constructorTrace.indexOf(58));
    }
}

