/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.os;

import java.io.IOException;
import java.io.OutputStream;

public class TeeOutputStream
extends OutputStream {
    private long size = 0L;
    private final long[] writeTime;
    protected final OutputStream[] destinations;
    protected boolean closeCalled = false;

    public TeeOutputStream(OutputStream[] destinations) {
        if (destinations == null) {
            throw new IllegalArgumentException("Destinations OutputStream can't be null");
        }
        if (destinations.length == 0) {
            throw new IllegalArgumentException("At least one destination OutputStream must be specified");
        }
        OutputStream[] arr$ = destinations;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            OutputStream destination = arr$[i$];
            if (destination != null) continue;
            throw new IllegalArgumentException("One of the outputstreams in the array is null");
        }
        this.writeTime = new long[destinations.length];
        this.destinations = destinations;
    }

    public void close() throws IOException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            int i = 0;
            while (i < this.destinations.length) {
                OutputStream stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.close();
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
        }
    }

    public void flush() throws IOException {
        if (!this.closeCalled) {
            int i = 0;
            while (i < this.destinations.length) {
                OutputStream stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.flush();
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
        }
    }

    public final long getSize() {
        return this.size;
    }

    public long[] getWriteTime() {
        return this.writeTime;
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("Array of bytes can't be null");
        }
        if (!this.closeCalled) {
            int i = 0;
            while (i < this.destinations.length) {
                OutputStream stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.write(b);
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
            this.size += (long)b.length;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("Array of bytes can't be null");
        }
        if (!this.closeCalled) {
            int i = 0;
            while (i < this.destinations.length) {
                OutputStream stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.write(b, off, len);
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
            this.size += (long)len;
        }
    }

    public void write(int b) throws IOException {
        if (!this.closeCalled) {
            int i = 0;
            while (i < this.destinations.length) {
                OutputStream stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.write(b);
                ++this.size;
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
            ++this.size;
        }
    }
}

