/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import com.gc.iotools.stream.base.AbstractInputStreamWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStreamOutputStream
extends AbstractInputStreamWrapper {
    private final long[] writeTime;
    private long markPosition = 0L;
    private long destinationPosition = 0L;
    private long sourcePosition = 0L;
    protected final OutputStream[] destinations;
    protected final boolean closeStreams;

    public TeeInputStreamOutputStream(InputStream source, OutputStream destination) {
        this(source, destination, true);
    }

    public TeeInputStreamOutputStream(InputStream source, OutputStream destination, boolean closeStreams) {
        this(source, closeStreams, destination);
    }

    public TeeInputStreamOutputStream(InputStream source, boolean closeStreams, OutputStream ... destinations) {
        super(source);
        if (destinations == null) {
            throw new IllegalArgumentException("Destinations OutputStream can't be null");
        }
        if (destinations.length == 0) {
            throw new IllegalArgumentException("At least one destination OutputStream must be specified");
        }
        for (OutputStream destination : destinations) {
            if (destination != null) continue;
            throw new IllegalArgumentException("One of the outputstreams in the array is null");
        }
        this.writeTime = new long[destinations.length];
        this.destinations = destinations;
        this.closeStreams = closeStreams;
    }

    public int available() throws IOException {
        return this.source.available();
    }

    public void closeOnce() throws IOException {
        IOException e1 = null;
        try {
            byte[] buffer = new byte[8192];
            while (this.innerRead(buffer, 0, buffer.length) > 0) {
            }
        }
        catch (IOException e) {
            e1 = new IOException("It's not possible to copy to the destination OutputStream.");
            e1.initCause(e);
        }
        if (this.closeStreams) {
            this.source.close();
            int i = 0;
            while (i < this.destinations.length) {
                long start = System.currentTimeMillis();
                this.destinations[i].close();
                long[] lArray = this.getWriteTime();
                int n = i++;
                lArray[n] = lArray[n] + (System.currentTimeMillis() - start);
            }
        }
        if (e1 != null) {
            throw e1;
        }
    }

    public int innerRead(byte[] b, int off, int len) throws IOException {
        int result = this.source.read(b, off, len);
        if (result > 0) {
            if (this.sourcePosition + (long)result > this.destinationPosition) {
                int newLen = (int)(this.sourcePosition + (long)result - this.destinationPosition);
                int newOff = off + (result - newLen);
                int i = 0;
                while (i < this.destinations.length) {
                    long start = System.currentTimeMillis();
                    this.destinations[i].write(b, newOff, newLen);
                    long[] lArray = this.getWriteTime();
                    int n = i++;
                    lArray[n] = lArray[n] + (System.currentTimeMillis() - start);
                }
                this.destinationPosition += (long)newLen;
            }
            this.sourcePosition += (long)result;
        }
        return result;
    }

    public void mark(int readLimit) {
        this.source.mark(readLimit);
        this.markPosition = this.sourcePosition;
    }

    public boolean markSupported() {
        return this.source.markSupported();
    }

    public int read() throws IOException {
        int result = this.source.read();
        if (result >= 0) {
            ++this.sourcePosition;
            if (this.sourcePosition > this.destinationPosition) {
                int i = 0;
                while (i < this.destinations.length) {
                    long start = System.currentTimeMillis();
                    this.destinations[i].write(result);
                    long[] lArray = this.getWriteTime();
                    int n = i++;
                    lArray[n] = lArray[n] + (System.currentTimeMillis() - start);
                }
                ++this.destinationPosition;
            }
        }
        return result;
    }

    public synchronized void reset() throws IOException {
        this.source.reset();
        this.sourcePosition = this.markPosition;
    }

    public long[] getWriteTime() {
        return this.writeTime;
    }
}

