/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.os;

import com.gc.iotools.stream.base.ExecutionModel;
import com.gc.iotools.stream.base.ExecutorServiceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutputStreamToInputStream<T>
extends OutputStream {
    private static final int DEFAULT_PIPE_SIZE = 4096;
    private static int defaultPipeSize = 4096;
    private static final Logger LOG = LoggerFactory.getLogger(OutputStreamToInputStream.class);
    private boolean closeCalled = false;
    private final boolean joinOnClose;
    private final PipedOutputStream wrappedPipedOS;
    private final Future<T> writingResult;

    public static void setDefaultBufferSize(int defaultPipeSize) {
        OutputStreamToInputStream.defaultPipeSize = defaultPipeSize;
    }

    public OutputStreamToInputStream() throws IOException {
        this(true, ExecutionModel.THREAD_PER_INSTANCE);
    }

    public OutputStreamToInputStream(boolean joinOnClose, ExecutionModel executionModel) throws IOException {
        this(joinOnClose, ExecutorServiceFactory.getExecutor(executionModel));
    }

    public OutputStreamToInputStream(boolean joinOnClose, ExecutorService executorService) throws IOException {
        if (executorService == null) {
            throw new IllegalArgumentException("executor service can't be null");
        }
        this.wrappedPipedOS = new PipedOutputStream();
        MyPipedInputStream pipedIS = new MyPipedInputStream(defaultPipeSize);
        pipedIS.connect(this.wrappedPipedOS);
        DataConsumer executingProcess = new DataConsumer(pipedIS);
        this.joinOnClose = joinOnClose;
        this.writingResult = executorService.submit(executingProcess);
    }

    @Override
    public final void close() throws IOException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.wrappedPipedOS.close();
            if (this.joinOnClose) {
                try {
                    this.writingResult.get();
                }
                catch (ExecutionException e) {
                    IOException e1 = new IOException("Problem producing data");
                    e1.initCause(e.getCause());
                    throw e1;
                }
                catch (InterruptedException e) {
                    IOException e1 = new IOException("Waiting of the thread has been interrupted");
                    e1.initCause(e);
                    throw e1;
                }
            }
        }
    }

    public final void close(long timeout, TimeUnit tu) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.wrappedPipedOS.close();
            if (this.joinOnClose) {
                this.writingResult.get(timeout, tu);
            }
        }
    }

    @Override
    public final void flush() throws IOException {
        this.wrappedPipedOS.flush();
    }

    public final T getResults() throws InterruptedException, ExecutionException {
        if (!this.closeCalled) {
            throw new IllegalStateException("Method close() must be called before getResults");
        }
        return this.writingResult.get();
    }

    @Override
    public final void write(byte[] bytes) throws IOException {
        this.wrappedPipedOS.write(bytes);
    }

    @Override
    public final void write(byte[] bytes, int offset, int length) throws IOException {
        this.wrappedPipedOS.write(bytes, offset, length);
    }

    @Override
    public final void write(int bytetowr) throws IOException {
        this.wrappedPipedOS.write(bytetowr);
    }

    protected abstract T doRead(InputStream var1) throws Exception;

    private class MyPipedInputStream
    extends PipedInputStream {
        MyPipedInputStream(int bufferSize) {
            this.buffer = new byte[bufferSize];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DataConsumer
    implements Callable<T> {
        private final InputStream inputstream;

        DataConsumer(InputStream istream) {
            this.inputstream = istream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            Object processResult;
            try {
                processResult = OutputStreamToInputStream.this.doRead(this.inputstream);
            }
            finally {
                this.emptyInputStream();
            }
            return processResult;
        }

        private void emptyInputStream() {
            boolean closed = false;
            try {
                while (this.inputstream.read() >= 0) {
                }
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("closed") > 0) {
                    LOG.debug("Stream already closed");
                    closed = true;
                } else {
                    LOG.error("IOException while empty InputStream a thread can be locked", (Throwable)e);
                }
            }
            catch (Throwable t) {
                LOG.error("Error while empty InputStream a thread can be locked", t);
            }
            this.tryCloseIs(closed);
        }

        private void tryCloseIs(boolean closed) {
            if (!closed) {
                try {
                    this.inputstream.close();
                }
                catch (Throwable e) {
                    LOG.error("Error closing Inputstream", e);
                }
            }
        }
    }
}

