/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.writer;

import java.io.IOException;
import java.io.Reader;

public class SizeLimitReader
extends Reader {
    private boolean closed = false;
    protected long currentPosition = 0L;
    protected Reader in;
    protected long markPosition = 0L;
    protected final long maxSize;

    public SizeLimitReader(Reader in, long maxSize) {
        this.in = in;
        this.maxSize = maxSize;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.in.close();
        }
    }

    public long getBytesLeft() {
        return this.maxSize - this.currentPosition;
    }

    public long getBytesRead() {
        return this.currentPosition;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    public void mark(int readlimit) throws IOException {
        this.in.mark(readlimit);
        this.markPosition = this.currentPosition;
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        int result;
        if (this.currentPosition >= this.maxSize) {
            result = -1;
        } else {
            result = this.in.read();
            if (result >= 0) {
                ++this.currentPosition;
            }
        }
        return result;
    }

    public int read(char[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(char[] b, int off, int len) throws IOException {
        int charactersRead;
        if (this.currentPosition >= this.maxSize) {
            charactersRead = -1;
        } else {
            int n = (int)Math.min(this.getBytesLeft(), (long)len);
            charactersRead = this.in.read(b, off, n);
            if (charactersRead > 0) {
                this.currentPosition += (long)charactersRead;
            }
        }
        return charactersRead;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.currentPosition = this.markPosition;
        this.markPosition = 0L;
    }

    public long skip(long n) throws IOException {
        long result;
        if (this.currentPosition >= this.maxSize) {
            result = -1L;
        } else {
            result = this.in.skip(Math.min(n, this.getBytesLeft()));
            if (result > 0L) {
                this.currentPosition += result;
            }
        }
        return result;
    }
}

