/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.reader;

import com.gc.iotools.stream.base.ExecutionModel;
import com.gc.iotools.stream.base.ExecutorServiceFactory;
import com.gc.iotools.stream.utils.LogUtils;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReaderFromWriter<T>
extends Reader {
    private static final List<String> ACTIVE_THREAD_NAMES = Collections.synchronizedList(new ArrayList());
    private static int defaultPipeSize = 4096;
    private static final Logger LOG;
    private boolean closeCalled = false;
    private Future<T> futureResult = null;
    private final boolean joinOnClose;
    private final PipedReader pipedReader;
    private final String callerId;
    protected final ExecutorService executorService;
    static /* synthetic */ Class class$com$gc$iotools$stream$reader$ReaderFromWriter$DataProducer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getActiveThreadNames() {
        String[] result;
        List<String> list = ACTIVE_THREAD_NAMES;
        synchronized (list) {
            result = ACTIVE_THREAD_NAMES.toArray(new String[0]);
        }
        return result;
    }

    public static void setDefaultPipeSize(int defaultPipeSize) {
        ReaderFromWriter.defaultPipeSize = defaultPipeSize;
    }

    public ReaderFromWriter() {
        this(ExecutionModel.THREAD_PER_INSTANCE);
    }

    public ReaderFromWriter(boolean joinOnClose, ExecutionModel executionModel) {
        this(joinOnClose, ExecutorServiceFactory.getExecutor(executionModel));
    }

    public ReaderFromWriter(boolean joinOnClose, ExecutorService executor) {
        this(joinOnClose, executor, defaultPipeSize);
    }

    public ReaderFromWriter(boolean joinOnClose, ExecutorService executor, int pipeBufferSize) {
        this.joinOnClose = joinOnClose;
        this.pipedReader = new MyPipedReader(pipeBufferSize);
        this.executorService = executor;
        this.callerId = LogUtils.getCaller(this.getClass());
    }

    private void checkInitialized() {
        if (this.futureResult == null) {
            PipedWriter pipedWriter = null;
            try {
                pipedWriter = new PipedWriter(this.pipedReader){
                    private boolean writerCloseCalled;
                    {
                        this.writerCloseCalled = false;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void close() throws IOException {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.writerCloseCalled) {
                                return;
                            }
                            this.writerCloseCalled = true;
                        }
                        super.close();
                    }
                };
            }
            catch (IOException e) {
                throw new RuntimeException("Error during pipe creaton", e);
            }
            DataProducer executingCallable = new DataProducer(this.callerId, pipedWriter);
            this.futureResult = this.executorService.submit(executingCallable);
            LOG.debug("thread created by[{}] queued for start.", (Object)this.callerId);
        }
    }

    public ReaderFromWriter(ExecutionModel executionModel) {
        this(false, executionModel);
    }

    public ReaderFromWriter(ExecutorService executor) {
        this(false, executor);
    }

    private void checkException() throws IOException {
        try {
            this.futureResult.get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            IOException e1 = new IOException("Exception producing data");
            e1.initCause(t);
            throw e1;
        }
        catch (InterruptedException e) {
            IOException e1 = new IOException("Thread interrupted");
            e1.initCause(e);
            throw e1;
        }
    }

    @Override
    public final void close() throws IOException {
        this.checkInitialized();
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.pipedReader.close();
            if (this.joinOnClose) {
                try {
                    this.getResult();
                }
                catch (Exception e) {
                    IOException e1 = new IOException("The internal stream threw exception");
                    e1.initCause(e);
                    throw e1;
                }
            }
        }
    }

    public T getResult() throws Exception {
        T result;
        if (!this.closeCalled) {
            throw new IllegalStateException("getResult() called before close().This method can be called only after the stream has been closed.");
        }
        try {
            result = this.futureResult.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
        return result;
    }

    protected abstract T produce(Writer var1) throws Exception;

    @Override
    public final int read() throws IOException {
        this.checkInitialized();
        int result = this.pipedReader.read();
        if (result < 0) {
            this.checkException();
        }
        return result;
    }

    @Override
    public final int read(char[] b, int off, int len) throws IOException {
        this.checkInitialized();
        int result = this.pipedReader.read(b, off, len);
        if (result < 0) {
            this.checkException();
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkInitialized();
        return super.skip(n);
    }

    static {
        Class<?> clazz = class$com$gc$iotools$stream$reader$ReaderFromWriter$DataProducer;
        if (clazz == null) {
            clazz = class$com$gc$iotools$stream$reader$ReaderFromWriter$DataProducer = new DataProducer[0].getClass().getComponentType();
        }
        LOG = LoggerFactory.getLogger((Class)clazz);
    }

    private final class MyPipedReader
    extends PipedReader {
        MyPipedReader(int bufferSize) {
            super(bufferSize);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DataProducer
    implements Callable<T> {
        private final String name;
        private final Writer writer;

        DataProducer(String threadName, Writer writer) {
            this.writer = writer;
            this.name = threadName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            Object result;
            String threadName = this.getName();
            ACTIVE_THREAD_NAMES.add(threadName);
            LOG.debug(new StringBuffer().append("thread [").append(threadName).append("] started.").toString());
            try {
                result = ReaderFromWriter.this.produce(this.writer);
            }
            finally {
                this.closeStream();
                ACTIVE_THREAD_NAMES.remove(threadName);
                LOG.debug(new StringBuffer().append("thread [").append(threadName).append("] closed.").toString());
            }
            return result;
        }

        private void closeStream() {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("closed") > 0) {
                    LOG.debug("Stream already closed");
                } else {
                    LOG.error("IOException closing Writer Thread might be locked", (Throwable)e);
                }
            }
            catch (Throwable t) {
                LOG.error("Error closing Reader Thread might be locked", t);
            }
        }

        String getName() {
            return this.name;
        }
    }
}

