/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is.inspection;

import com.gc.iotools.stream.utils.LogUtils;
import com.gc.iotools.stream.utils.StreamUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsInputStream
extends InputStream {
    private static Map<String, Long> instanceNumber = new HashMap<String, Long>();
    private static final Logger LOGGER;
    private static Map<String, BigInteger> totalBytes;
    private static Map<String, BigInteger> totalRead;
    private static Map<String, Long> totalTime;
    private final boolean automaticLog;
    private final String callerId;
    private final StatsInputStream chainStream;
    private boolean closeCalled = false;
    private final boolean fullReadOnClose;
    private final InputStream innerStream;
    private long markPosition = 0L;
    private long numberRead = 0L;
    private long size = 0L;
    private long time = 0L;
    static /* synthetic */ Class class$com$gc$iotools$stream$is$inspection$StatsInputStream;

    public StatsInputStream(InputStream source) {
        this(source, false);
    }

    public StatsInputStream(InputStream istream, boolean fullReadOnClose) {
        this(istream, fullReadOnClose, false);
    }

    public StatsInputStream(InputStream istream, boolean fullReadOnClose, boolean automaticLog) {
        this(istream, fullReadOnClose, automaticLog, null);
    }

    public StatsInputStream(InputStream istream, boolean fullReadOnClose, boolean automaticLog, StatsInputStream chainStream) {
        if (istream == null) {
            throw new IllegalArgumentException("InputStream can't be null");
        }
        this.innerStream = istream;
        this.fullReadOnClose = fullReadOnClose;
        this.automaticLog = automaticLog;
        this.callerId = LogUtils.getCaller(this.getClass());
        this.chainStream = chainStream;
        this.addToMapL(instanceNumber, 1L);
    }

    private void addToMap(Map<String, BigInteger> map, long value) {
        if (!map.containsKey(this.callerId)) {
            map.put(this.callerId, BigInteger.valueOf(value));
        } else {
            BigInteger mvalue = map.get(this.callerId);
            mvalue.add(BigInteger.valueOf(value));
        }
    }

    private void addToMapL(Map<String, Long> map, long value) {
        if (!map.containsKey(this.callerId)) {
            map.put(this.callerId, value);
        } else {
            long mvalue = map.get(this.callerId);
            map.put(this.callerId, mvalue + value);
        }
    }

    @Override
    public int available() throws IOException {
        return this.innerStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closeCalled) {
            long start = System.currentTimeMillis();
            this.closeCalled = true;
            try {
                if (this.fullReadOnClose) {
                    byte[] buffer = new byte[8192];
                    while (this.read(buffer) >= 0) {
                    }
                }
            }
            finally {
                this.innerStream.close();
                long timeElapsed = System.currentTimeMillis() - start;
                this.time += timeElapsed;
                this.addToMapL(totalTime, timeElapsed);
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.automaticLog) {
            this.logCurrentStatistics();
        }
        super.finalize();
    }

    public float getAverageBytePerRead() {
        return (float)this.size * 1.0f / (float)this.numberRead;
    }

    public float getBitRate() {
        return (float)this.size / 1024.0f / (float)TimeUnit.SECONDS.convert(this.getTime(), TimeUnit.MILLISECONDS);
    }

    public String getBitRateString() {
        return StreamUtils.getRateString(this.size, this.time);
    }

    public long getNumberRead() {
        return this.numberRead;
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        long time2 = this.time;
        if (this.chainStream != null) {
            time2 -= this.chainStream.getTime();
        }
        return time2;
    }

    public long getTime(TimeUnit tu) {
        if (tu == null) {
            throw new IllegalArgumentException("TimeUnit can't be null");
        }
        long convertedTime = tu.convert(this.time, TimeUnit.MILLISECONDS);
        if (this.chainStream != null) {
            convertedTime -= this.chainStream.getTime(tu);
        }
        return convertedTime;
    }

    public long getTotalNumberRead() {
        BigInteger totalReadBytes = totalRead.get(this.callerId);
        return totalReadBytes == null ? 0L : totalReadBytes.longValue();
    }

    public long getTotalTime(TimeUnit tu) {
        if (tu == null) {
            throw new IllegalArgumentException("TimeUnit can't be null");
        }
        Long totalTimeLocal = totalTime.get(this.callerId);
        long timeMs = totalTimeLocal == null ? 0L : totalTimeLocal;
        long convertedTotalTime = tu.convert(timeMs, TimeUnit.MILLISECONDS);
        if (this.chainStream != null) {
            convertedTotalTime -= this.chainStream.getTotalTime(tu);
        }
        return convertedTotalTime;
    }

    private void internallogCurrentStatistics(boolean addNotClosedWarning) {
        StringBuffer message = new StringBuffer("Time spent[");
        message.append(this.getTime());
        message.append("]ms, bytes read [");
        message.append(this.getSize());
        message.append("] at [");
        message.append(this.getBitRate());
        message.append("].");
        if (addNotClosedWarning) {
            message.append("The stream is being finalized and close() was not called.");
        }
        LOGGER.info(message.toString());
    }

    public boolean isFullReadOnClose() {
        return this.fullReadOnClose;
    }

    public void logCurrentStatistics() {
        this.internallogCurrentStatistics(false);
    }

    @Override
    public void mark(int readlimit) {
        long start = System.currentTimeMillis();
        this.innerStream.mark(readlimit);
        this.markPosition = this.size;
        long timeElapsed = System.currentTimeMillis() - start;
        this.time += timeElapsed;
        this.addToMapL(totalTime, timeElapsed);
    }

    @Override
    public boolean markSupported() {
        return this.innerStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        long start = System.currentTimeMillis();
        int read = this.innerStream.read();
        if (read >= 0) {
            ++this.size;
            this.addToMap(totalBytes, 1L);
        }
        this.addToMap(totalRead, 1L);
        ++this.numberRead;
        long timeElapsed = System.currentTimeMillis() - start;
        this.time += timeElapsed;
        this.addToMapL(totalTime, timeElapsed);
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        long start = System.currentTimeMillis();
        int read = this.innerStream.read(b);
        if (read >= 0) {
            this.size += (long)read;
            this.addToMap(totalBytes, read);
        }
        long timeElapsed = System.currentTimeMillis() - start;
        this.time += timeElapsed;
        this.addToMapL(totalTime, timeElapsed);
        ++this.numberRead;
        this.addToMap(totalRead, 1L);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long start = System.currentTimeMillis();
        int read = this.innerStream.read(b, off, len);
        if (read >= 0) {
            this.size += (long)read;
            this.addToMap(totalBytes, read);
        }
        ++this.numberRead;
        this.addToMap(totalRead, 1L);
        long timeElapsed = System.currentTimeMillis() - start;
        this.time += timeElapsed;
        this.addToMapL(totalTime, timeElapsed);
        return read;
    }

    @Override
    public void reset() throws IOException {
        long start = System.currentTimeMillis();
        this.innerStream.reset();
        this.size = this.markPosition;
        long timeElapsed = System.currentTimeMillis() - start;
        this.time += timeElapsed;
        this.addToMapL(totalTime, timeElapsed);
    }

    @Override
    public long skip(long n) throws IOException {
        long start = System.currentTimeMillis();
        long skipSize = this.innerStream.skip(n);
        this.size += skipSize;
        long timeElapsed = System.currentTimeMillis() - start;
        this.time += timeElapsed;
        this.addToMapL(totalTime, timeElapsed);
        return skipSize;
    }

    static {
        Class<?> clazz = class$com$gc$iotools$stream$is$inspection$StatsInputStream;
        if (clazz == null) {
            clazz = class$com$gc$iotools$stream$is$inspection$StatsInputStream = new StatsInputStream[0].getClass().getComponentType();
        }
        LOGGER = LoggerFactory.getLogger((Class)clazz);
        totalBytes = new HashMap<String, BigInteger>();
        totalRead = new HashMap<String, BigInteger>();
        totalTime = new HashMap<String, Long>();
    }
}

