/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.base;

import com.gc.iotools.stream.base.ExecutionModel;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ExecutorServiceFactory {
    private static ExecutorService executor = new ThreadPoolExecutor(0, 20, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(500));
    private static final ExecutorService SINGLE_EXECUTOR = Executors.newSingleThreadExecutor();

    public static ExecutorService getExecutor(ExecutionModel tmodel) {
        ExecutorService result;
        switch (1.$SwitchMap$com$gc$iotools$stream$base$ExecutionModel[tmodel.ordinal()]) {
            case 1: {
                result = new OneShotThreadExecutor();
                break;
            }
            case 2: {
                result = executor;
                break;
            }
            case 3: {
                result = SINGLE_EXECUTOR;
                break;
            }
            default: {
                throw new UnsupportedOperationException("ExecutionModel [" + (Object)((Object)tmodel) + "] not supported");
            }
        }
        return result;
    }

    public static void init() {
        ExecutorServiceFactory.setDefaultThreadPoolExecutor(new ThreadPoolExecutor(0, 20, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(500)));
    }

    public static void setDefaultThreadPoolExecutor(ExecutorService executor) {
        ExecutorServiceFactory.executor = executor;
    }

    public static void shutDown() {
        executor.shutdown();
    }

    private ExecutorServiceFactory() {
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OneShotThreadExecutor
    extends AbstractExecutorService {
        private final ExecutorService exec = Executors.newSingleThreadExecutor();

        private OneShotThreadExecutor() {
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.exec.awaitTermination(timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            this.exec.execute(command);
            this.shutdown();
        }

        @Override
        public boolean isShutdown() {
            return this.exec.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.exec.isTerminated();
        }

        @Override
        public void shutdown() {
            this.exec.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.exec.shutdownNow();
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            Future<T> result = this.exec.submit(task);
            this.shutdown();
            return result;
        }
    }
}

