/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.utils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogUtils {
    public static String getCaller(Class<?> clazz) {
        return LogUtils.getCaller(clazz, 1);
    }

    public static String getCaller(Class<?> me, int nframes) {
        String result;
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        int stackTracePosition = LogUtils.getCallerPosition(me, stes);
        if (stackTracePosition >= stes.length - 1) {
            result = new StringBuffer().append("class [").append(me.getName()).append("] not found in caller's stack trace.").toString();
        } else {
            StringBuffer resBuffer = new StringBuffer();
            for (int i = stackTracePosition; i < stes.length && i < stackTracePosition + nframes; ++i) {
                StackTraceElement stelement = stes[i];
                String className = stelement.getClassName();
                String simpleClassName = className.substring(className.lastIndexOf(46) + 1);
                if (resBuffer.length() > 0) {
                    resBuffer.append(" / ");
                }
                resBuffer.append(new StringBuffer().append(simpleClassName).append(".").append(stelement.getMethodName()).append(":").append(stelement.getLineNumber()).toString());
            }
            result = resBuffer.toString();
        }
        return result;
    }

    private static int getCallerPosition(Class<?> me, StackTraceElement[] stes) {
        int stackTracePosition;
        StackTraceElement stackTraceElement;
        boolean foundCaller = false;
        boolean foundClazz = false;
        for (stackTracePosition = 0; stackTracePosition < stes.length && !foundCaller; foundCaller |= (foundClazz |= me.getName().equals(stackTraceElement.getClassName())) && !me.getName().equals(stackTraceElement.getClassName()), ++stackTracePosition) {
            stackTraceElement = stes[stackTracePosition];
        }
        return --stackTracePosition;
    }

    private LogUtils() {
    }
}

