/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import com.gc.iotools.stream.base.AbstractInputStreamWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStreamOutputStream
extends AbstractInputStreamWrapper {
    private static final int BUF_SIZE = 8192;
    private long markPosition = 0L;
    private long destinationPosition = 0L;
    private long sourcePosition = 0L;
    protected final OutputStream destination;
    protected final boolean closeStreams;

    public TeeInputStreamOutputStream(InputStream source, OutputStream destination) {
        this(source, destination, true);
    }

    public TeeInputStreamOutputStream(InputStream source, OutputStream destination, boolean closeStreams) {
        super(source);
        this.destination = destination;
        this.closeStreams = closeStreams;
    }

    public int available() throws IOException {
        return this.source.available();
    }

    public void closeOnce() throws IOException {
        IOException e1 = null;
        try {
            byte[] buffer = new byte[8192];
            while (this.innerRead(buffer, 0, 8192) > 0) {
            }
        }
        catch (IOException e) {
            e1 = new IOException("It's not possible to copy to the destination OutputStream.");
            e1.initCause(e);
        }
        if (this.closeStreams) {
            this.source.close();
            this.destination.close();
        }
        if (e1 != null) {
            throw e1;
        }
    }

    public int innerRead(byte[] b, int off, int len) throws IOException {
        int result = this.source.read(b, off, len);
        if (result > 0) {
            if (this.sourcePosition + (long)result > this.destinationPosition) {
                int newLen = (int)(this.sourcePosition + (long)result - this.destinationPosition);
                int newOff = off + (result - newLen);
                this.destination.write(b, newOff, newLen);
                this.destinationPosition += (long)newLen;
            }
            this.sourcePosition += (long)result;
        }
        return result;
    }

    public void mark(int readLimit) {
        this.source.mark(readLimit);
        this.markPosition = this.sourcePosition;
    }

    public boolean markSupported() {
        return this.source.markSupported();
    }

    public int read() throws IOException {
        int result = this.source.read();
        if (result >= 0) {
            ++this.sourcePosition;
            if (this.sourcePosition > this.destinationPosition) {
                this.destination.write(result);
                ++this.destinationPosition;
            }
        }
        return result;
    }

    public synchronized void reset() throws IOException {
        this.source.reset();
        this.sourcePosition = this.markPosition;
    }
}

