/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import java.io.IOException;
import java.io.InputStream;

public class StatsInputStream
extends InputStream {
    private static final int BUF_SIZE = 32768;
    private boolean closeCalled = false;
    private final boolean fullReadOnClose;
    private final InputStream innerStream;
    private long markPosition = 0L;
    private long size = 0L;
    private long time = 0L;

    public StatsInputStream(InputStream source) {
        this(source, true);
    }

    public StatsInputStream(InputStream istream, boolean fullReadOnClose) {
        if (istream == null) {
            throw new IllegalArgumentException("InputStream can't be null");
        }
        this.innerStream = istream;
        this.fullReadOnClose = fullReadOnClose;
    }

    public int available() throws IOException {
        return this.innerStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closeCalled) {
            long start = System.currentTimeMillis();
            this.closeCalled = true;
            try {
                if (this.fullReadOnClose) {
                    byte[] buffer = new byte[32768];
                    while (this.read(buffer) >= 0) {
                    }
                }
            }
            finally {
                this.innerStream.close();
                this.time += System.currentTimeMillis() - start;
            }
        }
    }

    public long getSize() {
        return this.size;
    }

    public long getTime() {
        return this.time;
    }

    public float getRate() {
        return (float)this.size / 1024.0f / ((float)this.time / 1000.0f);
    }

    public boolean isFullReadOnClose() {
        return this.fullReadOnClose;
    }

    public void mark(int readlimit) {
        long start = System.currentTimeMillis();
        this.innerStream.mark(readlimit);
        this.markPosition = this.size;
        this.time += System.currentTimeMillis() - start;
    }

    public boolean markSupported() {
        return this.innerStream.markSupported();
    }

    public int read() throws IOException {
        long start = System.currentTimeMillis();
        int readed = this.innerStream.read();
        if (readed >= 0) {
            ++this.size;
        }
        this.time += System.currentTimeMillis() - start;
        return readed;
    }

    public int read(byte[] b) throws IOException {
        long start = System.currentTimeMillis();
        int readed = this.innerStream.read(b);
        if (readed >= 0) {
            this.size += (long)readed;
        }
        this.time += System.currentTimeMillis() - start;
        return readed;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        long start = System.currentTimeMillis();
        int readed = this.innerStream.read(b, off, len);
        if (readed >= 0) {
            this.size += (long)readed;
        }
        this.time += System.currentTimeMillis() - start;
        return readed;
    }

    public void reset() throws IOException {
        long start = System.currentTimeMillis();
        this.innerStream.reset();
        this.size = this.markPosition;
        this.time += System.currentTimeMillis() - start;
    }

    public long skip(long n) throws IOException {
        long start = System.currentTimeMillis();
        long skipSize = this.innerStream.skip(n);
        this.size += skipSize;
        this.time += System.currentTimeMillis() - start;
        return skipSize;
    }
}

