/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import com.gc.iotools.stream.base.AbstractInputStreamWrapper;
import com.gc.iotools.stream.store.SeekableStore;
import com.gc.iotools.stream.store.Store;
import com.gc.iotools.stream.store.ThresholdStore;
import java.io.IOException;
import java.io.InputStream;

public class RandomAccessInputStream
extends AbstractInputStreamWrapper {
    public static final int DEFAULT_DISK_TRHESHOLD = 65536;
    protected long sourcePosition = 0L;
    protected long randomAccessIsPosition = 0L;
    protected long markPosition = 0L;
    protected long markLimit = 0L;
    private Store store;

    public RandomAccessInputStream(InputStream source) {
        this(source, 65536);
    }

    public RandomAccessInputStream(InputStream source, int threshold) {
        super(source);
        this.store = new ThresholdStore(threshold);
    }

    public RandomAccessInputStream(InputStream source, SeekableStore store) {
        super(source);
        if (store == null) {
            throw new IllegalArgumentException("store can't be null.");
        }
        this.store = store;
    }

    public int available() throws IOException {
        return (int)Math.min(this.sourcePosition - this.randomAccessIsPosition + (long)this.source.available(), Integer.MAX_VALUE);
    }

    public Store getStore() {
        return this.store;
    }

    public synchronized void mark(int readLimit) {
        this.markLimit = readLimit;
        this.markPosition = this.randomAccessIsPosition;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void reset() throws IOException {
        if (this.markLimit >= 0L && this.randomAccessIsPosition - this.markPosition > this.markLimit) {
            throw new IOException("Reset to an invalid mark.");
        }
        this.randomAccessIsPosition = this.markPosition;
        ((SeekableStore)this.store).seek(this.markPosition);
    }

    public void seek(long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("Seek to negative position [" + position + "]");
        }
        if (!(this.store instanceof SeekableStore)) {
            throw new IllegalStateException("Seek was called but the store[" + this.store + "] is not an instance of [" + SeekableStore.class + "]");
        }
        long len = position - this.randomAccessIsPosition;
        if (len > 0L) {
            long n = this.skip(len);
            if (n < len) {
                throw new IOException("Requested seek to [" + position + "] but the stream is only [" + (n + this.randomAccessIsPosition) + "] bytes long.");
            }
        } else if (len < 0L) {
            this.randomAccessIsPosition = position;
            ((SeekableStore)this.store).seek(position);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[randomAccPos=" + this.randomAccessIsPosition + ",srcPos=" + this.sourcePosition + ", store=" + this.store + "]";
    }

    protected void closeOnce() throws IOException {
        this.store.cleanup();
        this.source.close();
    }

    protected int innerRead(byte[] b, int off, int len) throws IOException {
        int n;
        if (this.sourcePosition == this.randomAccessIsPosition) {
            n = this.source.read(b, off, len);
            if (n > 0) {
                this.sourcePosition += (long)n;
                this.randomAccessIsPosition += (long)n;
                this.store.put(b, off, n);
            }
        } else if (this.randomAccessIsPosition < this.sourcePosition) {
            int efflen = (int)Math.min((long)len, this.sourcePosition - this.randomAccessIsPosition);
            n = this.store.get(b, off, efflen);
            if (n <= 0) {
                throw new IllegalStateException("Problem reading from buffer. Expecting bytes [" + efflen + "] but buffer is empty.");
            }
            this.randomAccessIsPosition += (long)n;
        } else {
            throw new IllegalStateException("randomAccessIsPosition[" + this.randomAccessIsPosition + "] > sourcePosition[" + this.sourcePosition + "]");
        }
        return n;
    }

    public void setStore(Store store) {
        this.store = store;
    }
}

