/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.utils;

import java.io.IOException;
import java.io.InputStream;

public final class StreamUtils {
    public static byte[] read(InputStream source, int size) throws IOException {
        byte[] test = new byte[size];
        int n = StreamUtils.tryReadFully(source, test, 0, size);
        byte[] result = test;
        if (n < size) {
            if (n <= 0) {
                result = null;
            } else {
                result = new byte[n];
                System.arraycopy(test, 0, result, 0, n);
            }
        }
        return result;
    }

    public static int tryReadFully(InputStream source, byte[] buffer, int offset, int len) throws IOException {
        int n;
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException("len [" + len + "] < 0");
        }
        for (n = 0; n < len; n += count) {
            count = source.read(buffer, offset + n, len - n);
            if (count >= 0) continue;
            if (n != 0) break;
            n = count;
            break;
        }
        return n;
    }

    private StreamUtils() {
    }
}

