/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.store;

import com.gc.iotools.stream.store.MemoryStore;
import com.gc.iotools.stream.store.SeekableStore;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThresholdStore
implements SeekableStore {
    private static final Logger LOG = LoggerFactory.getLogger(ThresholdStore.class);
    private static final int BUF_SIZE = 8192;
    private final int treshold;
    private File fileStorage;
    private RandomAccessFile fileAccess;
    private long size = 0L;
    private long position = 0L;
    private final MemoryStore ms = new MemoryStore();

    public int getTreshold() {
        return this.treshold;
    }

    public long getSize() {
        return this.size;
    }

    public void setPosition(long position) {
        this.position = position;
    }

    public ThresholdStore(int treshold) {
        this.treshold = treshold;
    }

    public ThresholdStore(int treshold, File file) {
        this.treshold = treshold;
        this.fileStorage = file;
    }

    public void cleanup() {
        this.size = 0L;
        this.position = 0L;
        this.ms.cleanup();
        if (this.fileAccess != null) {
            try {
                this.fileAccess.close();
            }
            catch (IOException e) {
                LOG.warn("Exception in closing the temporary stream associated to file [" + this.fileStorage.getName() + "] it " + "is possible to continue but some" + " resources are not released.", (Throwable)e);
            }
            this.fileAccess = null;
        }
        if (this.fileStorage != null && this.fileStorage.exists()) {
            boolean deleted = this.fileStorage.delete();
            if (!deleted) {
                this.fileStorage.deleteOnExit();
                LOG.warn("Temporary file [" + this.fileStorage.getName() + "] was not deleted. It " + "is possible to continue but some" + " resources are not released.");
            }
            this.fileStorage = null;
        }
    }

    public int get(byte[] bytes, int offset, int length) throws IOException {
        int result;
        if (this.size < (long)this.treshold) {
            result = this.ms.get(bytes, offset, length);
        } else {
            if (this.position != this.fileAccess.getFilePointer()) {
                this.fileAccess.seek(this.position);
            }
            result = this.fileAccess.read(bytes, offset, length);
        }
        this.position += (long)Math.max(result, 0);
        return result;
    }

    public void put(byte[] bytes, int offset, int length) throws IOException {
        if (length <= 0) {
            throw new IllegalArgumentException("lenght = [" + length + "]");
        }
        if (this.size + (long)length < (long)this.treshold) {
            this.ms.put(bytes, offset, length);
        } else {
            if (this.size < (long)this.treshold) {
                int len;
                if (this.fileStorage == null) {
                    this.fileStorage = File.createTempFile("iotools-storage", ".tmp");
                }
                this.fileAccess = new RandomAccessFile(this.fileStorage, "rw");
                byte[] buffer = new byte[8192];
                this.ms.seek(0L);
                while ((len = this.ms.get(buffer, 0, buffer.length)) > 0) {
                    this.fileAccess.write(buffer, 0, len);
                }
                this.ms.cleanup();
            } else {
                long fp = this.fileAccess.getFilePointer();
                if (fp != this.size) {
                    this.fileAccess.seek(this.size);
                }
            }
            this.fileAccess.write(bytes, offset, length);
        }
        this.size += (long)length;
    }

    public void seek(long position) throws IOException {
        if (this.position != position) {
            this.position = position;
            if (position <= this.size) {
                if (this.size < (long)this.treshold) {
                    this.ms.seek(position);
                } else {
                    long fp = this.fileAccess.getFilePointer();
                    if (fp != position) {
                        this.fileAccess.seek(position);
                    }
                }
            } else {
                throw new IOException("Seek at posiotion [" + position + "]outside buffer size[" + this.size + "]");
            }
        }
    }

    protected void finalize() throws Throwable {
        this.cleanup();
    }

    public String toString() {
        String str = this.getClass().getSimpleName() + "[pos=" + this.position + ",size=" + this.size;
        str = this.fileStorage != null ? str + ",file=" + this.fileStorage : str + ",ms=" + this.ms;
        if (this.fileAccess != null) {
            try {
                str = str + ",fp=" + this.fileAccess.getFilePointer();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return str + "]";
    }
}

