/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.os;

import java.io.IOException;
import java.io.OutputStream;

public class SizeRecorderOutputStream
extends OutputStream {
    private boolean closeCalled;
    private final OutputStream innerOs;
    private long size = 0L;

    public SizeRecorderOutputStream(OutputStream destination) {
        this.innerOs = destination;
    }

    public void close() throws IOException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.innerOs.close();
        }
    }

    public void flush() throws IOException {
        this.innerOs.flush();
    }

    public long getSize() {
        return this.size;
    }

    public void write(byte[] b) throws IOException {
        this.innerOs.write(b);
        this.size += (long)b.length;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.innerOs.write(b, off, len);
        this.size += (long)len;
    }

    public void write(int b) throws IOException {
        this.innerOs.write(b);
        ++this.size;
    }
}

