/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class FileBufferedInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 8192;
    private static final Logger LOG = LoggerFactory.getLogger(FileBufferedInputStream.class);
    private long currentPosition = 0L;
    private InputStream fileIs = null;
    private OutputStream fileOs;
    private int markLimit = 0;
    private long markPos = 0L;
    private final InputStream original;
    private File tempFile = null;

    public FileBufferedInputStream(InputStream source) {
        this.original = source;
    }

    public int available() throws IOException {
        int result = this.fileIs != null ? this.fileIs.available() + this.original.available() : this.original.available();
        return result;
    }

    public void close() throws IOException {
        try {
            if (this.fileIs != null) {
                this.fileIs.close();
            }
        }
        catch (IOException e) {
            LOG.debug("Problem closing internal inputStream", (Throwable)e);
        }
        this.cleanup();
        this.original.close();
    }

    public synchronized void mark(int markLimit) {
        boolean mark;
        boolean bl = mark = markLimit != 0;
        if (mark) {
            try {
                if (this.tempFile == null) {
                    this.tempFile = File.createTempFile("iotools-filebufferis", ".tmp");
                    this.tempFile.deleteOnExit();
                    this.currentPosition = 0L;
                }
                this.fileOs = new FileOutputStream(this.tempFile, true);
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("File [" + this.tempFile + "] not found. maybe " + "temporary directory was cleaned.", e);
            }
            catch (IOException e) {
                throw new IllegalStateException("Problem creating temporary file", e);
            }
            this.markPos = this.currentPosition;
        } else if (this.fileIs == null && this.markLimit != 0) {
            this.cleanup();
        }
        this.markLimit = markLimit;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        byte[] buf = new byte[1];
        int n = this.read(buf);
        int result = n > 0 ? buf[0] : n;
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n;
        boolean markActive;
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException("b.length[" + b.length + "] offset[" + off + "] length[" + len + "");
        }
        if (len == 0) {
            return 0;
        }
        boolean bl = markActive = this.markLimit != 0;
        if (this.fileIs != null) {
            n = this.fileIs.read(b, off, len);
            if (n < 0) {
                this.fileIs.close();
                this.fileIs = null;
                if (!markActive) {
                    this.cleanup();
                }
                n = this.readAndWriteToOs(b, off, len, markActive);
            } else {
                this.currentPosition += (long)n;
            }
        } else {
            n = this.readAndWriteToOs(b, off, len, markActive);
        }
        return n;
    }

    public synchronized void reset() throws IOException {
        if (this.tempFile == null) {
            throw new IOException("Restet to an invalid mark");
        }
        this.fileOs.close();
        this.fileOs = null;
        this.fileIs = new FileInputStream(this.tempFile);
        if (this.markPos > 0L) {
            this.fileIs.skip(this.markPos);
        }
        this.currentPosition = this.markPos;
        this.markLimit = 0;
    }

    public long skip(long n) throws IOException {
        long result = 0L;
        if (this.fileIs != null) {
            long skipped = this.fileIs.skip(n);
            this.currentPosition += skipped;
            if (this.currentPosition - this.markPos > (long)this.markLimit && this.markLimit > 0) {
                this.fileIs.close();
                this.fileIs = null;
                this.cleanup();
            }
            if (skipped < n) {
                this.skipAndCopy(n - skipped);
            }
        } else if (this.markLimit != 0) {
            this.skipAndCopy(n);
        } else {
            result = this.original.skip(n);
        }
        return result;
    }

    private void cleanup() {
        if (this.fileOs != null) {
            try {
                this.fileOs.close();
            }
            catch (IOException e) {
                LOG.debug("Exception closing the fileOutputStream", (Throwable)e);
            }
            this.fileOs = null;
        }
        if (this.tempFile != null) {
            boolean del = this.tempFile.delete();
            if (!del) {
                LOG.warn("can not delete [" + this.tempFile.getName() + "]");
            }
            this.tempFile = null;
        }
    }

    private int readAndWriteToOs(byte[] b, int off, int len, boolean markActive) throws IOException {
        int n = this.original.read(b, off, len);
        if (n > 0 && markActive) {
            boolean markInsideLimit;
            this.currentPosition += (long)n;
            boolean bl = markInsideLimit = this.currentPosition - this.markPos < (long)this.markLimit;
            if (this.markLimit < 0 || this.markLimit > 0 && markInsideLimit) {
                this.fileOs.write(b, off, n);
            } else {
                this.markLimit = 0;
                this.cleanup();
            }
        }
        return n;
    }

    private void skipAndCopy(long n) throws IOException {
        byte[] buf = new byte[8192];
        long readed = 0L;
        for (long i = 0L; i < n && readed >= 0L; i += readed) {
            int maxLen = (int)Math.min((long)buf.length, n - i);
            readed = this.read(buf, 0, maxLen);
        }
    }

    protected void finalize() throws Throwable {
        if (this.fileIs != null) {
            this.fileIs.close();
            this.fileIs = null;
        }
        this.cleanup();
    }
}

