/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.os;

import com.gc.iotools.stream.base.ExecutionModel;
import com.gc.iotools.stream.base.ExecutorServiceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutputStreamToInputStream<T>
extends OutputStream {
    private static final Log LOG = LogFactory.getLog(OutputStreamToInputStream.class);
    private boolean closeCalled = false;
    private final boolean joinOnClose;
    private final PipedOutputStream wrappedPipedOS;
    private final Future<T> writingResult;

    public OutputStreamToInputStream() throws IOException {
        this(true, ExecutionModel.THREAD_PER_INSTANCE);
    }

    public OutputStreamToInputStream(boolean joinOnClose, ExecutionModel em) throws IOException {
        this(joinOnClose, ExecutorServiceFactory.getExecutor(em));
    }

    public OutputStreamToInputStream(boolean joinOnClose, ExecutorService executor) throws IOException {
        String callerId = this.getCaller();
        this.wrappedPipedOS = new PipedOutputStream();
        PipedInputStream pipedIS = new PipedInputStream(this.wrappedPipedOS);
        DataConsumerRunnable executingProcess = new DataConsumerRunnable(callerId, pipedIS);
        this.joinOnClose = joinOnClose;
        this.writingResult = executor.submit(executingProcess);
    }

    @Override
    public final void close() throws IOException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.wrappedPipedOS.close();
            if (this.joinOnClose) {
                try {
                    this.writingResult.get();
                }
                catch (ExecutionException e) {
                    IOException e1 = new IOException("Problem producing data");
                    e1.initCause(e.getCause());
                    throw e1;
                }
                catch (Exception e) {
                    IOException e1 = new IOException("Problem producing data");
                    e1.initCause(e);
                    throw e1;
                }
            }
        }
    }

    public final void close(long timeout, TimeUnit tu) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.wrappedPipedOS.close();
            if (this.joinOnClose) {
                this.writingResult.get(timeout, tu);
            }
        }
    }

    @Override
    public final void flush() throws IOException {
        this.wrappedPipedOS.flush();
    }

    public final T getResults() throws InterruptedException, ExecutionException {
        if (!this.closeCalled) {
            throw new IllegalStateException("Method close() must be called before getResults");
        }
        return this.writingResult.get();
    }

    @Override
    public final void write(byte[] bytes) throws IOException {
        this.wrappedPipedOS.write(bytes);
    }

    @Override
    public final void write(byte[] bytes, int offset, int length) throws IOException {
        this.wrappedPipedOS.write(bytes, offset, length);
    }

    @Override
    public final void write(int bytetowr) throws IOException {
        this.wrappedPipedOS.write(bytetowr);
    }

    private String getCaller() {
        Exception exception = new Exception();
        StackTraceElement[] stes = exception.getStackTrace();
        StackTraceElement caller = stes[3];
        String result = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1) + "callBy:" + caller.toString();
        LOG.debug((Object)("Open [" + result + "]"));
        return result;
    }

    protected abstract T doRead(InputStream var1) throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DataConsumerRunnable
    implements Callable<T> {
        private final InputStream inputstream;

        DataConsumerRunnable(String callerId, InputStream istream) {
            this.inputstream = istream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            Object processResult;
            try {
                processResult = OutputStreamToInputStream.this.doRead(this.inputstream);
            }
            finally {
                this.emptyInputStream();
            }
            return processResult;
        }

        private void emptyInputStream() {
            boolean closed = false;
            try {
                while (this.inputstream.read() >= 0) {
                }
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("closed") > 0) {
                    LOG.debug((Object)"Stream already closed");
                    closed = true;
                } else {
                    LOG.error((Object)"IOException while empty InputStream a thread can be locked", (Throwable)e);
                }
            }
            catch (Throwable t) {
                LOG.error((Object)"Error while empty InputStream a thread can be locked", t);
            }
            this.tryCloseIs(closed);
        }

        private void tryCloseIs(boolean closed) {
            if (!closed) {
                try {
                    this.inputstream.close();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Error closing Inputstream", e);
                }
            }
        }
    }
}

