/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStreamOutputStream
extends InputStream {
    protected boolean closed = false;
    protected final OutputStream destination;
    protected final InputStream source;
    protected final boolean closeStreams;

    public TeeInputStreamOutputStream(InputStream source, OutputStream destination) {
        this(source, destination, true);
    }

    public TeeInputStreamOutputStream(InputStream source, OutputStream destination, boolean closeStreams) {
        this.source = source;
        this.destination = destination;
        this.closeStreams = closeStreams;
    }

    public int available() throws IOException {
        return this.source.available();
    }

    public void close() throws IOException {
        if (!this.closed) {
            IOException e1 = null;
            this.closed = true;
            try {
                int n = 0;
                byte[] buffer = new byte[8192];
                while ((n = this.source.read(buffer)) > 0) {
                    this.destination.write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                e1 = new IOException("It's not possible to copy to the OutputStream");
                e1.initCause(e);
            }
            if (this.closeStreams) {
                this.source.close();
                this.destination.close();
            }
            if (e1 != null) {
                throw e1;
            }
        }
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int result = this.source.read();
        if (result >= 0) {
            this.destination.write(result);
        }
        return result;
    }

    public int read(byte[] b) throws IOException {
        int result = this.source.read(b);
        if (result > 0) {
            this.destination.write(b, 0, result);
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.source.read(b, off, len);
        if (result > 0) {
            this.destination.write(b, off, result);
        }
        return result;
    }

    public void reset() throws IOException {
        throw new IOException("Reset not supported");
    }

    public long skip(long n) throws IOException {
        long curPos = 0L;
        int readLen = 0;
        byte[] buf = new byte[8192];
        while (curPos < n && readLen >= 0) {
            readLen = this.read(buf);
            if (readLen <= 0) continue;
            curPos += (long)readLen;
        }
        return curPos;
    }
}

