/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import java.io.IOException;
import java.io.InputStream;

public class SizeReaderInputStream
extends InputStream {
    private boolean closeCalled = false;
    private final boolean fullReadOnClose;
    private final InputStream innerStream;
    private long markPosition = 0L;
    private long size = 0L;

    public SizeReaderInputStream(InputStream istream) {
        this(istream, true);
    }

    public SizeReaderInputStream(InputStream istream, boolean fullReadOnClose) {
        this.innerStream = istream;
        this.fullReadOnClose = fullReadOnClose;
    }

    public int available() throws IOException {
        return this.innerStream.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            try {
                if (this.fullReadOnClose) {
                    byte[] buffer = new byte[32768];
                    while (this.read(buffer) >= 0) {
                    }
                }
            }
            finally {
                this.innerStream.close();
            }
        }
    }

    public long getSize() {
        return this.size;
    }

    public boolean isFullReadOnClose() {
        return this.fullReadOnClose;
    }

    public void mark(int readlimit) {
        this.innerStream.mark(readlimit);
        this.markPosition = this.size;
    }

    public boolean markSupported() {
        return this.innerStream.markSupported();
    }

    public int read() throws IOException {
        int readed = this.innerStream.read();
        if (readed >= 0) {
            ++this.size;
        }
        return readed;
    }

    public int read(byte[] b) throws IOException {
        int readed = this.innerStream.read(b);
        if (readed >= 0) {
            this.size += (long)readed;
        }
        return readed;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int readed = this.innerStream.read(b, off, len);
        if (readed >= 0) {
            this.size += (long)readed;
        }
        return readed;
    }

    public void reset() throws IOException {
        this.innerStream.reset();
        this.size = this.markPosition;
    }

    public long skip(long n) throws IOException {
        long skipSize = this.innerStream.skip(n);
        this.size += skipSize;
        return skipSize;
    }
}

