/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import com.gc.iotools.stream.base.ExecutionModel;
import com.gc.iotools.stream.base.ExecutorServiceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class InputStreamFromOutputStream
extends InputStream {
    private static final List<String> ACTIVE_THREAD_NAMES = Collections.synchronizedList(new ArrayList());
    private static final Log LOG = LogFactory.getLog(InputStreamFromOutputStream.class);
    private boolean closeCalled = false;
    private final DataProducerRunnable executingRunnable;
    private final PipedInputStream pipedIS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getActiveThreadNames() {
        String[] result;
        List<String> list = ACTIVE_THREAD_NAMES;
        synchronized (list) {
            result = ACTIVE_THREAD_NAMES.toArray(new String[ACTIVE_THREAD_NAMES.size()]);
        }
        return result;
    }

    public InputStreamFromOutputStream() {
        this(ExecutionModel.THREAD_PER_INSTANCE);
    }

    public InputStreamFromOutputStream(ExecutionModel tmodel) {
        this(ExecutorServiceFactory.getExecutor(tmodel));
    }

    public InputStreamFromOutputStream(Executor executor) {
        String callerId = this.getCaller();
        PipedOutputStream pipedOS = null;
        try {
            this.pipedIS = new PipedInputStream();
            pipedOS = new PipedOutputStream(this.pipedIS);
        }
        catch (IOException e) {
            throw new RuntimeException("Error during pipe creaton", e);
        }
        this.executingRunnable = new DataProducerRunnable(callerId, pipedOS);
        String tName = this.executingRunnable.getName();
        executor.execute(this.executingRunnable);
        LOG.debug((Object)("thread invoked by[" + tName + "] queued for start."));
    }

    public final void close() throws IOException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.pipedIS.close();
        }
    }

    public final int read() throws IOException {
        int result = this.pipedIS.read();
        if (result < 0 && this.executingRunnable.exception != null) {
            throw this.executingRunnable.exception;
        }
        return result;
    }

    public final int read(byte[] b) throws IOException {
        int result = this.pipedIS.read(b);
        if (result < 0 && this.executingRunnable.exception != null) {
            throw this.executingRunnable.exception;
        }
        return result;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        int result = this.pipedIS.read(b, off, len);
        if (result < 0 && this.executingRunnable.exception != null) {
            throw this.executingRunnable.exception;
        }
        return result;
    }

    private String getCaller() {
        Exception exception = new Exception();
        StackTraceElement[] stes = exception.getStackTrace();
        boolean found = false;
        StackTraceElement caller = null;
        for (int i = 0; i < stes.length && !found; ++i) {
            caller = stes[i];
            found = !this.getClass().equals(caller.getClass());
        }
        String result = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1) + "callBy:" + caller.toString();
        LOG.debug((Object)("OpenedBy [" + result + "]"));
        return result;
    }

    protected abstract void produce(OutputStream var1) throws Exception;

    private final class DataProducerRunnable
    implements Runnable {
        private IOException exception = null;
        private final Log LOGGER = LogFactory.getLog(DataProducerRunnable.class);
        private String name = null;
        private OutputStream outputStream = null;

        DataProducerRunnable(String threadName, OutputStream ostream) {
            this.outputStream = ostream;
            this.name = threadName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String threadName = this.getName();
            ACTIVE_THREAD_NAMES.add(threadName);
            try {
                InputStreamFromOutputStream.this.produce(this.outputStream);
            }
            catch (Throwable e) {
                this.LOGGER.error((Object)"Error during data production.", e);
                this.exception = new IOException("Error producing data for class [" + this.getClass().getName() + "]");
                this.exception.initCause(e);
            }
            finally {
                this.closeStream();
                ACTIVE_THREAD_NAMES.remove(threadName);
                this.LOGGER.debug((Object)("thread [" + this.getName() + "] closed"));
            }
        }

        private void closeStream() {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                if (e.getMessage() != null && e.getMessage().indexOf("closed") > 0) {
                    this.LOGGER.debug((Object)"Stream already closed");
                } else {
                    this.LOGGER.error((Object)"IOException closing OutputStream Thread might be locked", (Throwable)e);
                }
            }
            catch (Throwable t) {
                this.LOGGER.error((Object)"Error closing InputStream Thread might be locked", t);
            }
        }

        final String getName() {
            return this.name;
        }
    }
}

