/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe.plugins;

import it.jnrpe.ICommandLine;
import it.jnrpe.ReturnValue;
import it.jnrpe.Status;
import it.jnrpe.plugins.IPluginInterface;
import it.jnrpe.plugins.IPluginInterfaceEx;
import it.jnrpe.plugins.PluginBase;
import it.jnrpe.plugins.PluginCommandLine;
import it.jnrpe.plugins.PluginDefinition;
import it.jnrpe.plugins.PluginOption;
import it.jnrpe.utils.BadThresholdException;
import java.util.Collection;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.OptionException;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.util.HelpFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginProxy
extends PluginBase {
    private IPluginInterface m_plugin = null;
    private PluginDefinition m_pluginDef;
    private Group m_MainOptionsGroup = null;
    private final String m_sDescription;

    public PluginProxy(IPluginInterface plugin, PluginDefinition pluginDef) {
        this.m_plugin = plugin;
        this.m_pluginDef = pluginDef;
        this.m_sDescription = this.m_pluginDef.getDescription();
        GroupBuilder gBuilder = new GroupBuilder();
        for (PluginOption po : pluginDef.getOptions()) {
            gBuilder = gBuilder.withOption(po.toOption());
        }
        this.m_MainOptionsGroup = gBuilder.create();
    }

    public Collection<PluginOption> getOptions() {
        return this.m_pluginDef.getOptions();
    }

    public ReturnValue execute(String[] args) throws BadThresholdException {
        try {
            HelpFormatter hf = new HelpFormatter();
            Parser p = new Parser();
            p.setGroup(this.m_MainOptionsGroup);
            p.setHelpFormatter(hf);
            CommandLine cl = p.parse(args);
            if (this.getListeners() != null && this.m_plugin instanceof IPluginInterfaceEx) {
                ((IPluginInterfaceEx)this.m_plugin).addListeners(this.getListeners());
            }
            Thread.currentThread().setContextClassLoader(this.m_plugin.getClass().getClassLoader());
            return this.m_plugin.execute(new PluginCommandLine(cl));
        }
        catch (OptionException e) {
            return new ReturnValue(Status.UNKNOWN, e.getMessage());
        }
    }

    public void printHelp() {
        String sDivider = "================================================================================";
        System.out.println(sDivider);
        System.out.println("PLUGIN NAME : " + this.m_pluginDef.getName());
        if (this.m_sDescription != null && this.m_sDescription.trim().length() != 0) {
            System.out.println(sDivider);
            System.out.println("Description : ");
            System.out.println();
            System.out.println(this.m_sDescription);
        }
        HelpFormatter hf = new HelpFormatter();
        hf.setGroup(this.m_MainOptionsGroup);
        hf.setDivider(sDivider);
        hf.print();
    }

    @Override
    public ReturnValue execute(ICommandLine cl) {
        return null;
    }
}

