/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe.plugins;

import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;

public final class PluginOption {
    private String m_sOption = null;
    private boolean m_bHasArgs = false;
    private Integer m_iArgsCount = null;
    private boolean m_bRequired = false;
    private boolean m_bArgsOptional = true;
    private String m_sArgName = null;
    private String m_sLongOpt = null;
    private String m_sType = null;
    private String m_sValueSeparator = null;
    private String m_sDescription = null;

    public String getOption() {
        return this.m_sOption;
    }

    public PluginOption setOption(String sOption) {
        this.m_sOption = sOption;
        return this;
    }

    public boolean hasArgs() {
        return this.m_bHasArgs;
    }

    public PluginOption setHasArgs(boolean bHasArgs) {
        this.m_bHasArgs = bHasArgs;
        return this;
    }

    public Integer getArgsCount() {
        return this.m_iArgsCount;
    }

    public PluginOption setArgsCount(Integer iArgCount) {
        this.m_iArgsCount = iArgCount;
        return this;
    }

    public String getRequired() {
        return "" + this.m_bRequired;
    }

    public PluginOption setRequired(boolean bRequired) {
        this.m_bRequired = bRequired;
        return this;
    }

    public Boolean getArgsOptional() {
        return this.m_bArgsOptional;
    }

    public PluginOption setArgsOptional(Boolean bArgsOptional) {
        this.m_bArgsOptional = bArgsOptional;
        return this;
    }

    public String getArgName() {
        return this.m_sArgName;
    }

    public PluginOption setArgName(String sArgName) {
        this.m_sArgName = sArgName;
        return this;
    }

    public String getLongOpt() {
        return this.m_sLongOpt;
    }

    public PluginOption setLongOpt(String sLongOpt) {
        this.m_sLongOpt = sLongOpt;
        return this;
    }

    public String getType() {
        return this.m_sType;
    }

    public PluginOption setType(String sType) {
        this.m_sType = sType;
        return this;
    }

    public String getValueSeparator() {
        return this.m_sValueSeparator;
    }

    public PluginOption setValueSeparator(String sValueSeparator) {
        this.m_sValueSeparator = sValueSeparator;
        return this;
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public PluginOption setDescription(String sDescription) {
        this.m_sDescription = sDescription;
        return this;
    }

    Option toOption() {
        DefaultOptionBuilder oBuilder = new DefaultOptionBuilder();
        oBuilder.withShortName(this.m_sOption).withDescription(this.m_sDescription).withRequired(this.m_bRequired);
        if (this.m_sLongOpt != null) {
            oBuilder.withLongName(this.m_sLongOpt);
        }
        if (this.m_bHasArgs) {
            ArgumentBuilder aBuilder = new ArgumentBuilder();
            if (this.m_sArgName != null) {
                aBuilder.withName(this.m_sArgName);
            }
            if (this.m_bArgsOptional) {
                aBuilder.withMinimum(0);
            }
            if (this.m_iArgsCount != null) {
                aBuilder.withMaximum(this.m_iArgsCount.intValue());
            } else {
                aBuilder.withMaximum(1);
            }
            if (this.m_sValueSeparator != null && this.m_sValueSeparator.length() != 0) {
                aBuilder.withInitialSeparator(this.m_sValueSeparator.charAt(0));
                aBuilder.withSubsequentSeparator(this.m_sValueSeparator.charAt(0));
            }
            oBuilder.withArgument(aBuilder.create());
        }
        return oBuilder.create();
    }
}

