/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe.net;

import it.jnrpe.net.BadCRCException;
import it.jnrpe.net.JNRPEProtocolPacket;
import it.jnrpe.net.PacketType;
import it.jnrpe.net.PacketVersion;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import org.apache.commons.lang.StringUtils;

public class JNRPERequest
extends JNRPEProtocolPacket {
    public JNRPERequest(InputStream in) throws IOException, BadCRCException {
        this.fromInputStream(in);
        this.validate();
    }

    public JNRPERequest(String sCommand, String ... arguments) {
        this.init(sCommand, arguments);
    }

    JNRPERequest(String sCommand, String sArguments) {
        this.init(sCommand, sArguments);
    }

    private void init(String sCommand, String ... arguments) {
        if (arguments != null) {
            if (arguments.length == 1) {
                this.init(sCommand, arguments[0]);
                return;
            }
            Object[] ary = new String[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                ary[i] = arguments[i].indexOf(33) == -1 ? arguments[i] : "'" + arguments[i] + "'";
            }
            this.init(sCommand, StringUtils.join((Object[])ary, (char)'!'));
        } else {
            this.init(sCommand, (String)null);
        }
    }

    private void init(String sCommand, String sArguments) {
        String sTmpArgs = sArguments;
        if (sTmpArgs != null && sTmpArgs.startsWith("!")) {
            sTmpArgs = sTmpArgs.substring(1);
        }
        String sCommandBytes = !StringUtils.isBlank((String)sTmpArgs) ? sCommand + "!" + sTmpArgs : sCommand;
        this.setPacketVersion(PacketVersion.VERSION_2);
        super.setPacketType(PacketType.QUERY);
        super.initRandomBuffer();
        super.setDataBuffer(sCommandBytes);
        this.updateCRC();
    }

    private void updateCRC() {
        this.setCRC(0);
        int iCRC = 0;
        CRC32 crcAlg = new CRC32();
        crcAlg.update(this.toByteArray());
        iCRC = (int)crcAlg.getValue();
        this.setCRC(iCRC);
    }
}

