/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe;

import it.jnrpe.JNRPEServerThread;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ThreadTimeoutWatcher
extends Thread {
    private static final int DEFAULT_THREAD_TIMEOUT = 10;
    private static final long SECOND = 1000L;
    private List<ThreadData> m_ThreadList = Collections.synchronizedList(new ArrayList());
    private static int m_iPollingTime = 2;
    private static boolean m_bRun = true;
    private static int m_iThreadTimeout = 10;

    ThreadTimeoutWatcher() {
    }

    public void watch(Thread t) {
        this.m_ThreadList.add(new ThreadData(t));
    }

    public static void stopWatching() {
        m_bRun = false;
    }

    private void killThread(ThreadData td) {
        Thread t = td.getThread();
        if (t.isAlive()) {
            ((JNRPEServerThread)t).stopNow();
        }
    }

    private boolean killOldestThread() {
        ThreadData td = this.m_ThreadList.get(0);
        Thread t = td.getThread();
        if (!t.isAlive() || System.currentTimeMillis() - td.getStartTime() >= (long)m_iThreadTimeout * 1000L) {
            this.killThread(td);
            this.m_ThreadList.remove(0);
            return true;
        }
        return false;
    }

    public static void setThreadTimeout(int iTimeout) {
        m_iThreadTimeout = iTimeout;
    }

    public void run() {
        while (m_bRun) {
            try {
                Thread.sleep((long)m_iPollingTime * 1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                while (!this.m_ThreadList.isEmpty() && this.killOldestThread()) {
                }
            }
            catch (Throwable thr) {
            }
        }
        for (ThreadData td : this.m_ThreadList) {
            this.killThread(td);
        }
    }

    private static class ThreadData {
        private Thread m_thread;
        private long m_lStartTime;

        ThreadData(Thread t) {
            this.m_thread = t;
            this.m_lStartTime = System.currentTimeMillis();
        }

        public long getStartTime() {
            return this.m_lStartTime;
        }

        public Thread getThread() {
            return this.m_thread;
        }
    }
}

