/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe;

import it.jnrpe.JNRPEServerThread;
import it.jnrpe.JNRPEServerThreadFactory;
import it.jnrpe.ThreadTimeoutWatcher;
import it.jnrpe.commands.CommandInvoker;
import java.net.Socket;

class ThreadFactory {
    private static final int DEFAULT_THREAD_STOP_TIMEOUT = 5000;
    private ThreadTimeoutWatcher m_watchDog = null;
    private final CommandInvoker m_commandInvoker;

    public ThreadFactory(int iThreadTimeout, CommandInvoker commandInvoker) {
        this.m_commandInvoker = commandInvoker;
        this.m_watchDog = new ThreadTimeoutWatcher();
        ThreadTimeoutWatcher.setThreadTimeout(iThreadTimeout);
        this.m_watchDog.start();
    }

    public JNRPEServerThread createNewThread(Socket s) {
        JNRPEServerThread t = JNRPEServerThreadFactory.getInstance(this.m_commandInvoker).createNewThread(s);
        this.m_watchDog.watch(t);
        return t;
    }

    public void shutdown() {
        try {
            ThreadFactory threadFactory = this;
            threadFactory.m_watchDog.stopWatching();
            this.m_watchDog.join(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

