/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe;

import it.jnrpe.PerformanceData;
import it.jnrpe.Status;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public final class ReturnValue {
    private List<PerformanceData> m_vPerformanceData = new ArrayList<PerformanceData>();
    private Status m_returnCode;
    private String m_sMessage;

    public ReturnValue() {
    }

    public ReturnValue(String sMessage) {
        this.m_returnCode = Status.OK;
        this.m_sMessage = sMessage;
    }

    public ReturnValue(int iReturnCode, String sMessage) {
        this.m_returnCode = Status.fromIntValue(iReturnCode);
        this.m_sMessage = sMessage;
    }

    public ReturnValue(Status status, String sMessage) {
        this.m_returnCode = status;
        this.m_sMessage = sMessage;
    }

    public ReturnValue withReturnCode(int iReturnCode) {
        this.m_returnCode = Status.fromIntValue(iReturnCode);
        return this;
    }

    public ReturnValue withStatus(Status status) {
        if (status == null) {
            throw new IllegalArgumentException("Status cannot be null");
        }
        this.m_returnCode = status;
        return this;
    }

    public ReturnValue withMessage(String sMessage) {
        this.m_sMessage = sMessage;
        return this;
    }

    public int getReturnCode() {
        return this.m_returnCode.intValue();
    }

    public Status getStatus() {
        return this.m_returnCode;
    }

    public String getMessage() {
        if (this.m_vPerformanceData.isEmpty()) {
            return this.m_sMessage;
        }
        StringBuffer res = new StringBuffer(this.m_sMessage).append("|");
        for (PerformanceData pd : this.m_vPerformanceData) {
            res.append(pd.toPerformanceString()).append(' ');
        }
        return res.toString();
    }

    public ReturnValue withPerformanceData(String sLabel, Long value, UnitOfMeasure uom, String sWarningRange, String sCriticalRange, Long minimumValue, Long maximumValue) {
        BigDecimal bdValue = null;
        BigDecimal bdMin = null;
        BigDecimal bdMax = null;
        if (value != null) {
            bdValue = new BigDecimal(value);
        }
        if (minimumValue != null) {
            bdMin = new BigDecimal(minimumValue);
        }
        if (maximumValue != null) {
            bdMax = new BigDecimal(maximumValue);
        }
        this.m_vPerformanceData.add(new PerformanceData(sLabel, bdValue, uom, sWarningRange, sCriticalRange, bdMin, bdMax));
        return this;
    }

    public ReturnValue withPerformanceData(String sLabel, BigDecimal value, UnitOfMeasure uom, String sWarningRange, String sCriticalRange, BigDecimal minimumValue, BigDecimal maximumValue) {
        this.m_vPerformanceData.add(new PerformanceData(sLabel, value, uom, sWarningRange, sCriticalRange, minimumValue, maximumValue));
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnitOfMeasure {
        microseconds,
        milliseconds,
        seconds,
        percentage,
        bytes,
        kilobytes,
        megabytes,
        gigabytes,
        terabytes,
        counter;

    }
}

