/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe;

import it.jnrpe.ReturnValue;
import java.math.BigDecimal;
import java.text.DecimalFormat;

class PerformanceData {
    private final String m_sLabel;
    private final BigDecimal m_Value;
    private final ReturnValue.UnitOfMeasure m_uom;
    private final String m_sWarningRange;
    private final String m_sCriticalRange;
    private final BigDecimal m_MinimumValue;
    private final BigDecimal m_MaximumValue;
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.000000");

    public PerformanceData(String sLabel, BigDecimal sValue, ReturnValue.UnitOfMeasure uom, String sWarningRange, String sCriticalRange, BigDecimal sMinimumValue, BigDecimal sMaximumValue) {
        this.m_sLabel = sLabel;
        this.m_Value = sValue;
        this.m_uom = uom;
        this.m_sWarningRange = sWarningRange;
        this.m_sCriticalRange = sCriticalRange;
        this.m_MinimumValue = sMinimumValue;
        this.m_MaximumValue = sMaximumValue;
    }

    public String toPerformanceString() {
        StringBuffer res = new StringBuffer().append(this.quote(this.m_sLabel)).append("=").append(DECIMAL_FORMAT.format(this.m_Value));
        if (this.m_uom != null) {
            switch (this.m_uom) {
                case milliseconds: {
                    res.append("ms");
                    break;
                }
                case microseconds: {
                    res.append("us");
                    break;
                }
                case seconds: {
                    res.append("s");
                    break;
                }
                case bytes: {
                    res.append("B");
                    break;
                }
                case kilobytes: {
                    res.append("KB");
                    break;
                }
                case megabytes: {
                    res.append("MB");
                    break;
                }
                case gigabytes: {
                    res.append("GB");
                    break;
                }
                case terabytes: {
                    res.append("TB");
                    break;
                }
                case percentage: {
                    res.append("%");
                    break;
                }
                case counter: {
                    res.append("c");
                }
            }
        }
        res.append(";");
        if (this.m_sWarningRange != null) {
            res.append(this.m_sWarningRange);
        }
        res.append(";");
        if (this.m_sCriticalRange != null) {
            res.append(this.m_sCriticalRange);
        }
        res.append(";");
        if (this.m_MinimumValue != null) {
            res.append(DECIMAL_FORMAT.format(this.m_MinimumValue));
        }
        res.append(";");
        if (this.m_MaximumValue != null) {
            res.append(DECIMAL_FORMAT.format(this.m_MaximumValue));
        }
        while (res.charAt(res.length() - 1) == ';') {
            res.deleteCharAt(res.length() - 1);
        }
        return res.toString();
    }

    private String quote(String sLabel) {
        if (sLabel.indexOf(32) == -1) {
            return sLabel;
        }
        return new StringBuffer("'").append(sLabel).append("'").toString();
    }
}

