/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe;

import it.jnrpe.IJNRPEListener;
import it.jnrpe.JNRPEServerThread;
import it.jnrpe.ThreadFactory;
import it.jnrpe.commands.CommandInvoker;
import it.jnrpe.events.EventsUtil;
import it.jnrpe.events.IJNRPEEventListener;
import it.jnrpe.events.LogEvent;
import it.jnrpe.utils.StreamManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JNRPEListenerThread
extends Thread
implements IJNRPEListener {
    private static final int SOLINGER_TIMEOUT = 10;
    private static final int DEFAULT_COMMAND_EXECUTION_TIMEOUT = 20000;
    private ServerSocket m_serverSocket = null;
    private List<InetAddress> m_vAcceptedHosts = new ArrayList<InetAddress>();
    private ThreadFactory m_threadFactory = null;
    private final String m_sBindingAddress;
    private final int m_iBindingPort;
    private final CommandInvoker m_commandInvoker;
    private boolean m_bSSL = false;
    private int m_iCommandExecutionTimeout = 20000;
    private static final String KEYSTORE_NAME = "keys.jks";
    private static final String KEYSTORE_PWD = "p@55w0rd";
    private Set<IJNRPEEventListener> m_vEventListeners = null;
    private boolean m_bShutdown = false;

    JNRPEListenerThread(Set<IJNRPEEventListener> vEventListeners, String sBindingAddress, int iBindingPort, CommandInvoker commandInvoker) {
        this.m_sBindingAddress = sBindingAddress;
        this.m_iBindingPort = iBindingPort;
        this.m_commandInvoker = commandInvoker;
        this.m_vEventListeners = vEventListeners;
    }

    public void enableSSL() {
        this.m_bSSL = true;
    }

    private SSLServerSocketFactory getSSLSocketFactory() throws KeyStoreException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        SSLContext ctx;
        StreamManager h = new StreamManager();
        try {
            InputStream ksStream = this.getClass().getClassLoader().getResourceAsStream(KEYSTORE_NAME);
            h.handle(ksStream);
            ctx = SSLContext.getInstance("SSLv3");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance("JKS");
            char[] passphrase = KEYSTORE_PWD.toCharArray();
            ks.load(ksStream, passphrase);
            kmf.init(ks, passphrase);
            ctx.init(kmf.getKeyManagers(), null, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLException("Unable to initialize SSLSocketFactory.\n" + e.getMessage());
        }
        finally {
            h.closeAll();
        }
        return ctx.getServerSocketFactory();
    }

    private void init() throws IOException, KeyManagementException, KeyStoreException, CertificateException, UnrecoverableKeyException {
        InetAddress addr = InetAddress.getByName(this.m_sBindingAddress);
        ServerSocketFactory sf = null;
        sf = this.m_bSSL ? this.getSSLSocketFactory() : ServerSocketFactory.getDefault();
        this.m_serverSocket = sf.createServerSocket(this.m_iBindingPort, 0, addr);
        if (this.m_serverSocket instanceof SSLServerSocket) {
            ((SSLServerSocket)this.m_serverSocket).setEnabledCipherSuites(((SSLServerSocket)this.m_serverSocket).getSupportedCipherSuites());
        }
        this.m_threadFactory = new ThreadFactory(this.m_iCommandExecutionTimeout, this.m_commandInvoker);
    }

    public void addAcceptedHosts(String sHost) throws UnknownHostException {
        InetAddress addr = InetAddress.getByName(sHost);
        this.m_vAcceptedHosts.add(addr);
    }

    @Override
    public void run() {
        try {
            this.init();
            StringBuffer msg = new StringBuffer("Listening on ");
            if (this.m_bSSL) {
                msg = msg.append("SSL/");
            }
            msg = msg.append(this.m_sBindingAddress).append(":").append(this.m_iBindingPort);
            EventsUtil.sendEvent(this.m_vEventListeners, (Object)this, LogEvent.INFO, msg.toString());
            while (true) {
                Socket clientSocket = this.m_serverSocket.accept();
                clientSocket.setSoLinger(false, 10);
                clientSocket.setSoTimeout(this.m_iCommandExecutionTimeout);
                if (!this.canAccept(clientSocket.getInetAddress())) {
                    clientSocket.close();
                    continue;
                }
                JNRPEServerThread kk = this.m_threadFactory.createNewThread(clientSocket);
                kk.configure(this, this.m_vEventListeners);
                kk.start();
            }
        }
        catch (SocketException se) {
            if (!this.m_bShutdown) {
                EventsUtil.sendEvent(this.m_vEventListeners, (Object)this, LogEvent.ERROR, "Unable to listen on " + this.m_sBindingAddress + ":" + this.m_iBindingPort + ": " + se.getMessage(), se);
            }
        }
        catch (Throwable e) {
            EventsUtil.sendEvent(this.m_vEventListeners, (Object)this, LogEvent.ERROR, e.getMessage(), e);
        }
        this.exit();
    }

    private synchronized void exit() {
        this.m_serverSocket = null;
        this.notifyAll();
        EventsUtil.sendEvent(this.m_vEventListeners, (Object)this, LogEvent.INFO, "Listener Closed");
    }

    @Override
    public synchronized void shutdown() {
        this.m_bShutdown = true;
        try {
            if (this.m_serverSocket != null) {
                this.m_serverSocket.close();
                while (this.m_serverSocket != null) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException ie) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean canAccept(InetAddress inetAddress) {
        for (InetAddress addr : this.m_vAcceptedHosts) {
            if (!addr.equals(inetAddress)) continue;
            return true;
        }
        EventsUtil.sendEvent(this.m_vEventListeners, (Object)this, LogEvent.INFO, "Connection refused from : " + inetAddress);
        return false;
    }
}

