/*
 * Copyright (c) 2012 Massimiliano Ziccardi
 *  
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 */
package it.jnrpe.events;

/**
 * This object represent an 'EXCEPTION' parameter.
 * It is usually used with the LogEvents to pass the exception
 * to be logged.
 * 
 * @author Massimiliano Ziccardi
 */
public class EventExceptionParam extends EventParam
{
    /**
     * Builds and initializes the exception parameter.
     * @param exc The exception.
     */
    public EventExceptionParam(final Throwable exc)
    {
        super("EXCEPTION", exc);
    }
}
