/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe.events;

import it.jnrpe.events.EventExceptionParam;
import it.jnrpe.events.EventMessageParam;
import it.jnrpe.events.EventParam;
import it.jnrpe.events.IJNRPEEventListener;
import it.jnrpe.events.LogEvent;
import it.jnrpe.events.SimpleEvent;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventsUtil {
    private EventsUtil() {
    }

    public static void sendEvent(Set<IJNRPEEventListener> vListeners, Object sender, LogEvent evt, String sMessage) {
        if (vListeners == null || vListeners.isEmpty()) {
            return;
        }
        EventsUtil.sendEvent(vListeners, sender, evt, sMessage, null);
    }

    public static void sendEvent(Set<IJNRPEEventListener> vListeners, Object sender, LogEvent evt, String sMessage, Throwable exception) {
        if (vListeners == null || vListeners.isEmpty()) {
            return;
        }
        if (sender == null || evt == null || sMessage == null) {
            throw new NullPointerException("The sender, evt and message parameter can't be null");
        }
        if (exception != null) {
            EventsUtil.sendEvent(vListeners, sender, evt.name(), new EventMessageParam(sMessage), new EventExceptionParam(exception));
        } else {
            EventsUtil.sendEvent(vListeners, sender, evt.name(), new EventMessageParam(sMessage));
        }
    }

    public static void sendEvent(Set<IJNRPEEventListener> vListeners, Object sender, String sCustomEvtType, EventParam ... vParams) {
        if (sender == null || sCustomEvtType == null) {
            throw new NullPointerException("The sender and event type parameter can't be null");
        }
        if (vListeners == null || vListeners.isEmpty()) {
            return;
        }
        SimpleEvent se = new SimpleEvent(sCustomEvtType, (Object[])vParams);
        for (IJNRPEEventListener listener : vListeners) {
            listener.receive(sender, se);
        }
    }
}

