/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe.commands;

import it.jnrpe.JNRPELIB;
import it.jnrpe.ReturnValue;
import it.jnrpe.Status;
import it.jnrpe.commands.CommandDefinition;
import it.jnrpe.commands.CommandRepository;
import it.jnrpe.events.EventsUtil;
import it.jnrpe.events.IJNRPEEventListener;
import it.jnrpe.events.LogEvent;
import it.jnrpe.plugins.PluginProxy;
import it.jnrpe.plugins.PluginRepository;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandInvoker {
    private final boolean m_bAcceptParams;
    private final PluginRepository m_pluginRepository;
    private final CommandRepository m_commandRepository;
    private final Set<IJNRPEEventListener> m_vListeners;

    public CommandInvoker(PluginRepository pluginRepository, CommandRepository commandRepository, Set<IJNRPEEventListener> vListeners) {
        this.m_bAcceptParams = true;
        this.m_pluginRepository = pluginRepository;
        this.m_commandRepository = commandRepository;
        this.m_vListeners = vListeners;
    }

    public ReturnValue invoke(String sCommandName, String[] args) {
        if (sCommandName.equals("_NRPE_CHECK")) {
            return new ReturnValue(Status.OK, JNRPELIB.VERSION);
        }
        CommandDefinition cd = this.m_commandRepository.getCommand(sCommandName);
        if (cd == null) {
            return new ReturnValue(Status.UNKNOWN, "Bad command");
        }
        return this.invoke(cd, args);
    }

    public ReturnValue invoke(CommandDefinition cd, String[] args) {
        PluginProxy plugin;
        String sPluginName = cd.getPluginName();
        String[] sCommandLine = cd.getCommandLine();
        if (this.m_bAcceptParams) {
            for (int j = 0; sCommandLine != null && j < sCommandLine.length; ++j) {
                for (int i = 0; i < args.length; ++i) {
                    sCommandLine[j] = sCommandLine[j].replaceAll("\\$[Aa][Rr][Gg]" + (i + 1) + "\\$", args[i]);
                    if (sCommandLine[j].indexOf(32) == -1) continue;
                    if (sCommandLine[j].indexOf(39) == -1) {
                        sCommandLine[j] = "'" + sCommandLine[j] + "'";
                        continue;
                    }
                    if (sCommandLine[j].indexOf(34) != -1) continue;
                    sCommandLine[j] = "\"" + sCommandLine[j] + "\"";
                }
            }
        }
        if ((plugin = (PluginProxy)this.m_pluginRepository.getPlugin(sPluginName)) == null) {
            EventsUtil.sendEvent(this.m_vListeners, (Object)this, LogEvent.INFO, "Unable to instantiate plugin named " + sPluginName);
            return new ReturnValue(Status.UNKNOWN, "Configuration error");
        }
        plugin.addListeners(this.m_vListeners);
        try {
            if (sCommandLine != null) {
                return plugin.execute(sCommandLine);
            }
            return plugin.execute(new String[0]);
        }
        catch (RuntimeException re) {
            return new ReturnValue(Status.UNKNOWN, "Plugin execution error: " + re.getMessage());
        }
        catch (Throwable thr) {
            return new ReturnValue(Status.UNKNOWN, "Plugin execution error: " + thr.getMessage());
        }
    }
}

