/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe.commands;

import it.jnrpe.commands.CommandOption;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CommandDefinition {
    private final String m_sName;
    private final String m_sPluginName;
    private String m_sArgs = null;
    private List<CommandOption> m_vOptions = new ArrayList<CommandOption>();

    public CommandDefinition(String sName, String sPluginName) {
        this.m_sName = sName;
        this.m_sPluginName = sPluginName;
    }

    public void setArgs(String sArgs) {
        this.m_sArgs = sArgs;
    }

    public String getName() {
        return this.m_sName;
    }

    public String getPluginName() {
        return this.m_sPluginName;
    }

    public String getArgs() {
        return this.m_sArgs;
    }

    private static String quote(String s) {
        if (s.indexOf(32) != -1) {
            return "\"" + s + "\"";
        }
        return s;
    }

    public String[] getCommandLine() {
        String[] vsRes = null;
        String[] args = this.m_sArgs != null ? CommandDefinition.split(this.m_sArgs) : new String[]{};
        ArrayList<String> vArgs = new ArrayList<String>();
        int iStartIndex = 0;
        for (CommandOption opt : this.m_vOptions) {
            String sArgName = opt.getName();
            String sArgVal = opt.getValue();
            vArgs.add((sArgName.length() == 1 ? "-" : "--") + sArgName);
            if (sArgVal == null) continue;
            vArgs.add(CommandDefinition.quote(sArgVal));
        }
        vsRes = new String[args.length + vArgs.size()];
        for (String sArg : vArgs) {
            vsRes[iStartIndex++] = sArg;
        }
        System.arraycopy(args, 0, vsRes, iStartIndex, args.length);
        return vsRes;
    }

    private static String[] split(String sCommandLine) {
        String regex = "[\"|']([^\"']*)[\"|']|([^ ]+)";
        ArrayList<String> res = new ArrayList<String>();
        Matcher m = Pattern.compile(regex).matcher(sCommandLine);
        while (m.find()) {
            if (m.group(1) != null) {
                res.add(m.group(1));
                continue;
            }
            res.add(m.group(2));
        }
        return res.toArray(new String[0]);
    }

    public CommandDefinition addArgument(CommandOption arg) {
        this.m_vOptions.add(arg);
        return this;
    }
}

