/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe;

import it.jnrpe.JNRPEListenerThread;
import it.jnrpe.ReturnValue;
import it.jnrpe.Status;
import it.jnrpe.commands.CommandInvoker;
import it.jnrpe.events.EventsUtil;
import it.jnrpe.events.IJNRPEEventListener;
import it.jnrpe.events.LogEvent;
import it.jnrpe.net.BadCRCException;
import it.jnrpe.net.JNRPERequest;
import it.jnrpe.net.JNRPEResponse;
import it.jnrpe.net.PacketVersion;
import it.jnrpe.utils.StreamManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JNRPEServerThread
extends Thread {
    private Socket m_Socket = null;
    private Boolean m_bStopped = Boolean.FALSE;
    private final CommandInvoker m_commandInvoker;
    private JNRPEListenerThread m_parent = null;
    private Set<IJNRPEEventListener> m_vListeners = null;

    public JNRPEServerThread(Socket socket, CommandInvoker commandInvoker) {
        super("JNRPEServerThread");
        this.m_Socket = socket;
        this.m_commandInvoker = commandInvoker;
    }

    void configure(JNRPEListenerThread listenerThread, Set<IJNRPEEventListener> vListeners) {
        this.m_parent = listenerThread;
        this.m_vListeners = vListeners;
    }

    private String[] split(String sCommandLine) {
        String regex = "[\"|']([^\"']*)[\"|']|([^\\!]+)";
        ArrayList<String> res = new ArrayList<String>();
        Matcher m = Pattern.compile(regex).matcher(sCommandLine);
        while (m.find()) {
            if (m.group(1) != null) {
                res.add(m.group(1));
                continue;
            }
            res.add(m.group(2));
        }
        return res.toArray(new String[0]);
    }

    public JNRPEResponse handleRequest(JNRPERequest req) {
        String[] vParts = this.split(req.getStringMessage());
        String sCommandName = vParts[0];
        Object[] vArgs = new String[vParts.length - 1];
        System.arraycopy(vParts, 1, vArgs, 0, vArgs.length);
        ReturnValue ret = this.m_commandInvoker.invoke(sCommandName, (String[])vArgs);
        if (ret == null) {
            String args = "";
            if (vArgs != null) {
                args = StringUtils.join((Object[])vArgs, (String)",");
            }
            ret = new ReturnValue(Status.UNKNOWN, "Command [" + sCommandName + "] with args [" + args + "] returned null");
        }
        JNRPEResponse res = new JNRPEResponse();
        res.setPacketVersion(PacketVersion.VERSION_2);
        res.setResultCode(ret.getStatus().intValue());
        res.setMessage(ret.getMessage());
        res.updateCRC();
        String sMessageInvokedLog = MessageFormat.format("Invoked command {0} - Status : {1} - Return Message : ''{2}''", sCommandName, ret.getStatus().name(), ret.getMessage());
        String sParamTraceLog = MessageFormat.format("Arguments : ''{0}''", this.argsToString((String[])vArgs));
        EventsUtil.sendEvent(this.m_vListeners, (Object)this.m_parent, LogEvent.DEBUG, sMessageInvokedLog);
        EventsUtil.sendEvent(this.m_vListeners, (Object)this.m_parent, LogEvent.TRACE, sParamTraceLog);
        return res;
    }

    private String argsToString(String[] vArgs) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(StringUtils.join((Object[])vArgs, (String)","));
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StreamManager streamMgr = new StreamManager();
        try {
            InputStream in = streamMgr.handle(this.m_Socket.getInputStream());
            JNRPEResponse res = null;
            JNRPERequest req = null;
            try {
                req = new JNRPERequest(in);
                switch (req.getPacketType()) {
                    case QUERY: {
                        res = this.handleRequest(req);
                        break;
                    }
                    default: {
                        res = new JNRPEResponse();
                        res.setPacketVersion(req.getPacketVersion());
                        res.setResultCode(Status.UNKNOWN.intValue());
                        res.setMessage("Invalid Packet Type");
                        res.updateCRC();
                        break;
                    }
                }
            }
            catch (BadCRCException e) {
                res = new JNRPEResponse();
                res.setPacketVersion(PacketVersion.VERSION_2);
                res.setResultCode(Status.UNKNOWN.intValue());
                res.setMessage("BAD REQUEST CRC");
                res.updateCRC();
            }
            Boolean bl = this.m_bStopped;
            synchronized (bl) {
                if (!this.m_bStopped.booleanValue()) {
                    OutputStream out = streamMgr.handle(this.m_Socket.getOutputStream());
                    out.write(res.toByteArray());
                }
            }
        }
        catch (IOException e) {
            EventsUtil.sendEvent(this.m_vListeners, (Object)this.m_parent, LogEvent.ERROR, "Error during socket operation", e);
        }
        finally {
            try {
                if (this.m_Socket != null && !this.m_Socket.isClosed()) {
                    this.m_Socket.shutdownInput();
                    this.m_Socket.shutdownOutput();
                    this.m_Socket.close();
                }
            }
            catch (IOException iOException) {}
            streamMgr.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopNow() {
        StreamManager streamMgr = new StreamManager();
        try {
            Boolean bl = this.m_bStopped;
            synchronized (bl) {
                if (!this.m_Socket.isClosed()) {
                    this.m_bStopped = Boolean.TRUE;
                    try {
                        JNRPEResponse res = new JNRPEResponse();
                        res.setPacketVersion(PacketVersion.VERSION_2);
                        res.setResultCode(Status.UNKNOWN.intValue());
                        res.setMessage("Command execution timeout");
                        res.updateCRC();
                        OutputStream out = streamMgr.handle(this.m_Socket.getOutputStream());
                        out.write(res.toByteArray());
                        this.m_Socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.isAlive()) {
                        this.interrupt();
                    }
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            streamMgr.closeAll();
        }
    }
}

