/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe;

import it.jnrpe.IJNRPEListener;
import it.jnrpe.JNRPEListenerThread;
import it.jnrpe.commands.CommandInvoker;
import it.jnrpe.commands.CommandRepository;
import it.jnrpe.events.IJNRPEEventListener;
import it.jnrpe.plugins.PluginRepository;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JNRPE {
    private final PluginRepository m_pluginRepository;
    private final CommandRepository m_commandRepository;
    private List<String> m_vAcceptedHosts = new ArrayList<String>();
    private Map<String, IJNRPEListener> m_mInstantiatedListeners = new HashMap<String, IJNRPEListener>();
    private Set<IJNRPEEventListener> m_vEventListeners = new HashSet<IJNRPEEventListener>();

    public JNRPE(PluginRepository pluginRepository, CommandRepository commandRepository) {
        if (pluginRepository == null) {
            throw new IllegalArgumentException("Plugin repository cannot be null");
        }
        if (commandRepository == null) {
            throw new IllegalArgumentException("Command repository cannot be null");
        }
        this.m_pluginRepository = pluginRepository;
        this.m_commandRepository = commandRepository;
    }

    public void listen(String sAddress, int iPort) throws UnknownHostException {
        this.listen(sAddress, iPort, true);
    }

    public void addEventListener(IJNRPEEventListener listener) {
        this.m_vEventListeners.add(listener);
    }

    public void listen(String sAddress, int iPort, boolean bSSL) throws UnknownHostException {
        JNRPEListenerThread bt = new JNRPEListenerThread(this.m_vEventListeners, sAddress, iPort, new CommandInvoker(this.m_pluginRepository, this.m_commandRepository, this.m_vEventListeners));
        for (String sAddr : this.m_vAcceptedHosts) {
            bt.addAcceptedHosts(sAddr);
        }
        if (bSSL) {
            bt.enableSSL();
        }
        bt.start();
        try {
            bt.join(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.m_mInstantiatedListeners.put(sAddress + iPort, bt);
    }

    public void addAcceptedHost(String sAddress) {
        this.m_vAcceptedHosts.add(sAddress);
    }

    public void shutdown() {
        if (this.m_mInstantiatedListeners.isEmpty()) {
            return;
        }
        for (IJNRPEListener listener : this.m_mInstantiatedListeners.values()) {
            listener.shutdown();
        }
    }
}

