/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe.plugins;

import it.jnrpe.ICommandLine;
import it.jnrpe.ReturnValue;
import it.jnrpe.Status;
import it.jnrpe.plugins.IPluginInterface;
import it.jnrpe.plugins.IPluginInterfaceEx;
import it.jnrpe.plugins.PluginBase;
import it.jnrpe.plugins.PluginCommandLine;
import it.jnrpe.plugins.PluginDefinition;
import it.jnrpe.plugins.PluginOption;
import java.util.Collection;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PluginProxy
extends PluginBase {
    private IPluginInterface m_plugin = null;
    private PluginDefinition m_pluginDef;
    private Options m_Options = new Options();
    private final String m_sDescription;

    public PluginProxy(IPluginInterface plugin, PluginDefinition pluginDef) {
        this.m_plugin = plugin;
        this.m_pluginDef = pluginDef;
        this.m_sDescription = this.m_pluginDef.getDescription();
        for (PluginOption po : pluginDef.getOptions()) {
            this.m_Options.addOption(po.toOption());
        }
    }

    public Collection<PluginOption> getOptions() {
        return this.m_pluginDef.getOptions();
    }

    public ReturnValue execute(String[] args) {
        PosixParser clp = new PosixParser();
        try {
            CommandLine cl = clp.parse(this.m_Options, args);
            if (this.getListeners() != null && this.m_plugin instanceof IPluginInterfaceEx) {
                ((IPluginInterfaceEx)this.m_plugin).addListeners(this.getListeners());
            }
            return this.m_plugin.execute(new PluginCommandLine(cl));
        }
        catch (ParseException e) {
            return new ReturnValue(Status.UNKNOWN, e.getMessage());
        }
    }

    public void printHelp() {
        if (this.m_sDescription != null && this.m_sDescription.trim().length() != 0) {
            System.out.println("Description : ");
            System.out.println(this.m_sDescription);
        }
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp(this.m_pluginDef.getName(), this.m_Options);
    }

    @Override
    public ReturnValue execute(ICommandLine cl) {
        return null;
    }
}

