/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe.net;

import it.jnrpe.net.BadCRCException;
import it.jnrpe.net.PacketType;
import it.jnrpe.net.PacketVersion;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.zip.CRC32;

class JNRPEProtocolPacket {
    private static final int MAX_PACKETBUFFER_LENGTH = 1024;
    private int m_iCRC = 0;
    private int m_iPacketType = 0;
    private int m_iPacketVersion = 0;
    private int m_iResultCode = 0;
    private byte[] m_vBuffer = new byte[1024];
    private byte[] m_vDummy = new byte[2];

    JNRPEProtocolPacket() {
    }

    public int getCRC() {
        return this.m_iCRC;
    }

    public PacketType getPacketType() {
        return PacketType.fromIntValue(this.m_iPacketType);
    }

    public PacketVersion getPacketVersion() {
        return PacketVersion.fromIntValue(this.m_iPacketVersion);
    }

    public void setCRC(int iCRC) {
        this.m_iCRC = iCRC;
    }

    protected void setPacketType(PacketType packetType) {
        this.m_iPacketType = packetType.intValue();
    }

    public void setPacketVersion(PacketVersion version) {
        this.m_iPacketVersion = version.intValue();
    }

    public int getResultCode() {
        return this.m_iResultCode;
    }

    public void setResultCode(int status) {
        this.m_iResultCode = status;
    }

    protected void fromInputStream(InputStream in) throws IOException {
        DataInputStream din = new DataInputStream(in);
        this.m_iPacketVersion = din.readShort();
        this.m_iPacketType = din.readShort();
        this.m_iCRC = din.readInt();
        this.m_iResultCode = din.readShort();
        din.readFully(this.m_vBuffer);
        din.readFully(this.m_vDummy);
    }

    public void validate() throws BadCRCException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            dout.writeShort(this.m_iPacketVersion);
            dout.writeShort(this.m_iPacketType);
            dout.writeInt(0);
            dout.writeShort(this.m_iResultCode);
            dout.write(this.m_vBuffer);
            dout.write(this.m_vDummy);
            dout.close();
            byte[] vBytes = bout.toByteArray();
            CRC32 crcAlg = new CRC32();
            crcAlg.update(vBytes);
            if ((int)crcAlg.getValue() != this.m_iCRC) {
                throw new BadCRCException("Bad CRC");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            dout.writeShort(this.m_iPacketVersion);
            dout.writeShort(this.m_iPacketType);
            dout.writeInt(this.m_iCRC);
            dout.writeShort(this.m_iResultCode);
            dout.write(this.m_vBuffer);
            dout.write(this.m_vDummy);
            dout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bout.toByteArray();
    }

    public String getStringMessage() {
        int iZeroIndex = 1023;
        for (int i = 0; i < 1024; ++i) {
            if (this.m_vBuffer[i] != 0) continue;
            iZeroIndex = i;
            break;
        }
        return new String(this.m_vBuffer, 0, iZeroIndex);
    }

    protected void _setMessage(String sMessage) {
        if (sMessage == null) {
            this.m_vBuffer[0] = 0;
            return;
        }
        System.arraycopy(sMessage.getBytes(), 0, this.m_vBuffer, 0, Math.min(sMessage.length(), 1024));
        if (sMessage.length() < 1024) {
            this.m_vBuffer[sMessage.length()] = 0;
        }
    }

    protected void initRandomBuffer() {
        Random r = new Random(System.currentTimeMillis());
        r.nextBytes(this.m_vBuffer);
        r.nextBytes(this.m_vDummy);
    }
}

