/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe.commands;

import it.jnrpe.ReturnValue;
import it.jnrpe.commands.CommandDefinition;
import it.jnrpe.commands.CommandRepository;
import it.jnrpe.plugins.PluginProxy;
import it.jnrpe.plugins.PluginRepository;

public class CommandInvoker {
    private final boolean m_bAcceptParams;
    private final PluginRepository m_pluginRepository;
    private final CommandRepository m_commandRepository;

    public CommandInvoker(PluginRepository pluginRepository, CommandRepository commandRepository) {
        this.m_bAcceptParams = true;
        this.m_pluginRepository = pluginRepository;
        this.m_commandRepository = commandRepository;
    }

    public ReturnValue invoke(String sCommandName, String[] args) {
        if (sCommandName.equals("_NRPE_CHECK")) {
            return new ReturnValue(0, "JNRPE v0.1/2.0");
        }
        CommandDefinition cd = this.m_commandRepository.getCommand(sCommandName);
        if (cd == null) {
            return new ReturnValue(3, "Bad command");
        }
        return this.invoke(cd, args);
    }

    public ReturnValue invoke(CommandDefinition cd, String[] args) {
        PluginProxy plugin;
        String sPluginName = cd.getPluginName();
        String[] sCommandLine = cd.getCommandLine();
        if (this.m_bAcceptParams) {
            for (int j = 0; sCommandLine != null && j < sCommandLine.length; ++j) {
                for (int i = 0; i < args.length; ++i) {
                    sCommandLine[j] = sCommandLine[j].replaceAll("\\$[Aa][Rr][Gg]" + (i + 1) + "\\$", args[i]);
                    if (sCommandLine[j].indexOf(32) == -1) continue;
                    if (sCommandLine[j].indexOf(39) == -1) {
                        sCommandLine[j] = "'" + sCommandLine[j] + "'";
                        continue;
                    }
                    if (sCommandLine[j].indexOf(34) != -1) continue;
                    sCommandLine[j] = "\"" + sCommandLine[j] + "\"";
                }
            }
        }
        if ((plugin = (PluginProxy)this.m_pluginRepository.getPlugin(sPluginName)) == null) {
            return new ReturnValue(3, "Configuration error");
        }
        try {
            if (sCommandLine != null) {
                return plugin.execute(sCommandLine);
            }
            return plugin.execute(new String[0]);
        }
        catch (RuntimeException re) {
            return new ReturnValue(3, "Plugin execution error: " + re.getMessage());
        }
        catch (Throwable thr) {
            return new ReturnValue(3, "Plugin execution error: " + thr.getMessage());
        }
    }
}

