/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe;

import it.jnrpe.IJNRPEListener;
import it.jnrpe.JNRPEListenerThread;
import it.jnrpe.commands.CommandInvoker;
import it.jnrpe.commands.CommandRepository;
import it.jnrpe.events.IJNRPEEventListener;
import it.jnrpe.plugins.PluginRepository;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JNRPE {
    private final PluginRepository m_pluginRepository;
    private final CommandRepository m_commandRepository;
    private List<String> m_vAcceptedHosts = new ArrayList<String>();
    private Map<String, IJNRPEListener> m_mInstantiatedListeners = new HashMap<String, IJNRPEListener>();
    private List<IJNRPEEventListener> m_vEventListeners = new ArrayList<IJNRPEEventListener>();

    public JNRPE(PluginRepository pluginRepository, CommandRepository commandRepository) {
        this.m_pluginRepository = pluginRepository;
        this.m_commandRepository = commandRepository;
    }

    public IJNRPEListener listen(String sAddress, int iPort) {
        return this.listen(sAddress, iPort, true);
    }

    public IJNRPEListener listen(String sAddress, int iPort, boolean bSSL) {
        JNRPEListenerThread bt = new JNRPEListenerThread(this.m_vEventListeners, sAddress, iPort, new CommandInvoker(this.m_pluginRepository, this.m_commandRepository));
        try {
            for (String sAddr : this.m_vAcceptedHosts) {
                bt.addAcceptedHosts(sAddr);
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (bSSL) {
            bt.enableSSL();
        }
        bt.start();
        this.m_mInstantiatedListeners.put(sAddress + iPort, bt);
        return bt;
    }

    public void addAcceptedHost(String sAddress) {
        this.m_vAcceptedHosts.add(sAddress);
    }

    public void shutdown() {
        if (this.m_mInstantiatedListeners.isEmpty()) {
            return;
        }
        for (IJNRPEListener listener : this.m_mInstantiatedListeners.values()) {
            listener.close();
        }
    }
}

