/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.math.BigDecimal;

class Threshold {
    private static final int MINVAL = 0;
    private static final int MAXVAL = 1;
    private static final int END = 99;
    private BigDecimal m_iMinVal = null;
    private BigDecimal m_iMaxVal = null;
    private boolean m_bNegate = false;
    private int m_iCurState = 0;

    Threshold(String sRange) {
        this.parseRange(sRange);
    }

    private void parseRange(String sRange) {
        byte[] vBytes = sRange.getBytes();
        ByteArrayInputStream bin = new ByteArrayInputStream(vBytes);
        PushbackInputStream pb = new PushbackInputStream(bin);
        byte b = 0;
        byte[] a_r = new byte[]{0};
        try {
            block14: while ((b = (byte)pb.read()) != -1) {
                String sNum;
                if (b == 64) {
                    if (this.m_iCurState != 0) {
                        System.err.println("PARSE ERROR");
                    }
                    this.m_bNegate = true;
                    continue;
                }
                if (b == 58) {
                    switch (this.m_iCurState) {
                        case 0: {
                            if (this.m_iMinVal == null) {
                                this.m_iMinVal = new BigDecimal(0);
                            }
                            this.m_iCurState = 1;
                            continue block14;
                        }
                        case 1: {
                            System.err.println("PARSE ERROR");
                            this.m_iCurState = 99;
                            continue block14;
                        }
                    }
                    this.m_iCurState = 1;
                }
                if (b == 126) {
                    switch (this.m_iCurState) {
                        case 0: {
                            this.m_iMinVal = new BigDecimal(Integer.MIN_VALUE);
                            continue block14;
                        }
                        case 1: {
                            this.m_iMaxVal = new BigDecimal(Integer.MAX_VALUE);
                            this.m_iCurState = 99;
                            continue block14;
                        }
                    }
                }
                StringBuffer sNumBuffer = new StringBuffer();
                do {
                    sNumBuffer.append((char)b);
                } while ((b = (byte)pb.read()) != -1 && (Character.isDigit((char)b) || b == 43 || b == 45));
                if (b != -1) {
                    pb.unread(b);
                }
                if ((sNum = sNumBuffer.toString()).trim().length() == 0) {
                    System.err.println("PARSE ERROR");
                }
                switch (this.m_iCurState) {
                    case 0: {
                        this.m_iMinVal = new BigDecimal(sNum.trim());
                        continue block14;
                    }
                    case 1: {
                        this.m_iMaxVal = new BigDecimal(sNum.trim());
                        continue block14;
                    }
                }
                this.m_iCurState = 99;
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (this.m_iCurState == 0) {
            this.m_iMaxVal = this.m_iMinVal;
            this.m_iMinVal = new BigDecimal(0);
        }
    }

    public boolean isValueInRange(int iVal) {
        return this.isValueInRange(new BigDecimal(iVal));
    }

    public boolean isValueInRange(BigDecimal val) {
        boolean bRes = true;
        if (this.m_iMinVal != null) {
            boolean bl = bRes = bRes && val.compareTo(this.m_iMinVal) >= 0;
        }
        if (this.m_iMaxVal != null) {
            boolean bl = bRes = bRes && val.compareTo(this.m_iMaxVal) <= 0;
        }
        if (this.m_bNegate) {
            return !bRes;
        }
        return bRes;
    }
}

