/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe;

import it.jnrpe.ReturnValue;
import it.jnrpe.commands.CommandInvoker;
import it.jnrpe.net.BadCRCException;
import it.jnrpe.net.JNRPERequest;
import it.jnrpe.net.JNRPEResponse;
import it.jnrpe.utils.StreamManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class JNRPEServerThread
extends Thread {
    private Socket socket = null;
    private Boolean m_bStopped = Boolean.FALSE;
    private final CommandInvoker m_commandInvoker;

    public JNRPEServerThread(Socket socket, CommandInvoker commandInvoker) {
        super("JNRPEServerThread");
        this.socket = socket;
        this.m_commandInvoker = commandInvoker;
    }

    public JNRPEResponse handleRequest(JNRPERequest req) {
        String[] vParts = req.getStringMessage().split("!");
        String sCommandName = vParts[0];
        String[] vArgs = new String[vParts.length - 1];
        System.arraycopy(vParts, 1, vArgs, 0, vArgs.length);
        ReturnValue ret = this.m_commandInvoker.invoke(sCommandName, vArgs);
        JNRPEResponse res = new JNRPEResponse();
        res.setPacketVersion(2);
        res.setResultCode(ret.getReturnCode());
        res.setMessage(ret.getMessage());
        res.updateCRC();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamManager streamMgr = new StreamManager();
        try {
            InputStream in = streamMgr.handle(this.socket.getInputStream());
            JNRPEResponse res = null;
            JNRPERequest req = null;
            try {
                req = new JNRPERequest(in);
                switch (req.getPacketType()) {
                    case 1: {
                        res = this.handleRequest(req);
                        break;
                    }
                    default: {
                        res = new JNRPEResponse();
                        res.setPacketVersion(req.getPacketVersion());
                        res.setResultCode(3);
                        res.setMessage("Invalid Packet Type");
                        res.updateCRC();
                        break;
                    }
                }
            }
            catch (BadCRCException e) {
                res = new JNRPEResponse();
                res.setPacketVersion(2);
                res.setResultCode(3);
                res.setMessage("BAD REQUEST CRC");
                res.updateCRC();
            }
            Boolean bl = this.m_bStopped;
            synchronized (bl) {
                if (!this.m_bStopped.booleanValue()) {
                    OutputStream out = streamMgr.handle(this.socket.getOutputStream());
                    out.write(res.toByteArray());
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    this.socket.close();
                }
            }
            catch (IOException e) {}
            streamMgr.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopNow() {
        StreamManager streamMgr = new StreamManager();
        try {
            Boolean bl = this.m_bStopped;
            synchronized (bl) {
                if (!this.socket.isClosed()) {
                    this.m_bStopped = Boolean.TRUE;
                    try {
                        JNRPEResponse res = new JNRPEResponse();
                        res.setPacketVersion(2);
                        res.setResultCode(3);
                        res.setMessage("Command execution timeout");
                        res.updateCRC();
                        OutputStream out = streamMgr.handle(this.socket.getOutputStream());
                        out.write(res.toByteArray());
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (this.isAlive()) {
                        this.interrupt();
                    }
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            streamMgr.closeAll();
        }
    }
}

