/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe;

import it.jnrpe.JNRPEListenerThread;
import it.jnrpe.commands.CommandInvoker;
import it.jnrpe.commands.CommandRepository;
import it.jnrpe.plugins.PluginRepository;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class JNRPE {
    private final PluginRepository m_pluginRepository;
    private final CommandRepository m_commandRepository;
    private List<String> m_vAcceptedHosts = new ArrayList<String>();

    public JNRPE(PluginRepository pluginRepository, CommandRepository commandRepository) {
        this.m_pluginRepository = pluginRepository;
        this.m_commandRepository = commandRepository;
    }

    public JNRPEListenerThread listen(String sAddress, int iPort) {
        return this.listen(sAddress, iPort, true);
    }

    public JNRPEListenerThread listen(String sAddress, int iPort, boolean bSSL) {
        JNRPEListenerThread bt = new JNRPEListenerThread(sAddress, iPort, new CommandInvoker(this.m_pluginRepository, this.m_commandRepository));
        try {
            for (String sAddr : this.m_vAcceptedHosts) {
                bt.addAcceptedHosts(sAddr);
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (bSSL) {
            bt.enableSSL();
        }
        bt.start();
        return bt;
    }

    public void addAcceptedHost(String sAddress) {
        this.m_vAcceptedHosts.add(sAddress);
    }
}

