/*
 * Decompiled with CFR 0.152.
 */
package it.jnrpe;

import it.jnrpe.JNRPEServerThread;
import it.jnrpe.ThreadFactory;
import it.jnrpe.commands.CommandInvoker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

class JNRPEListenerThread
extends Thread {
    private ServerSocket m_serverSocket = null;
    private List<InetAddress> m_vAcceptedHosts = new ArrayList<InetAddress>();
    private ThreadFactory m_threadFactory = null;
    private final String m_sBindingAddress;
    private final int m_iBindingPort;
    private final CommandInvoker m_commandInvoker;
    private boolean m_bSSL = false;
    private int m_iCommandExecutionTimeout = 20000;

    JNRPEListenerThread(String sBindingAddress, int iBindingPort, CommandInvoker commandInvoker) {
        this.m_sBindingAddress = sBindingAddress;
        this.m_iBindingPort = iBindingPort;
        this.m_commandInvoker = commandInvoker;
    }

    public void enableSSL() {
        this.m_bSSL = true;
    }

    public SSLServerSocketFactory getSSLSocketFactory(String sKeyStoreFile, String sKeyStorePwd, String sKeyStoreType) throws KeyStoreException, CertificateException, FileNotFoundException, IOException, UnrecoverableKeyException, KeyManagementException {
        SSLContext ctx;
        if (sKeyStoreFile == null) {
            throw new KeyStoreException("KEYSTORE HAS NOT BEEN SPECIFIED");
        }
        if (!new File(sKeyStoreFile).exists()) {
            throw new KeyStoreException("COULD NOT FIND KEYSTORE '" + sKeyStoreFile + "'");
        }
        if (sKeyStorePwd == null) {
            throw new KeyStoreException("KEYSTORE PASSWORD HAS NOT BEEN SPECIFIED");
        }
        try {
            ctx = SSLContext.getInstance("SSLv3");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore ks = KeyStore.getInstance(sKeyStoreType);
            ks.load(new FileInputStream(sKeyStoreFile), sKeyStorePwd.toCharArray());
            char[] passphrase = sKeyStorePwd.toCharArray();
            kmf.init(ks, passphrase);
            ctx.init(kmf.getKeyManagers(), null, new SecureRandom());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLException("Unable to initialize SSLSocketFactory.\n" + e.getMessage());
        }
        return ctx.getServerSocketFactory();
    }

    private void init() throws IOException, KeyManagementException, KeyStoreException, CertificateException, UnrecoverableKeyException {
        InetAddress addr = InetAddress.getByName(this.m_sBindingAddress);
        ServerSocketFactory sf = null;
        if (!this.m_bSSL) {
            sf = ServerSocketFactory.getDefault();
        }
        this.m_serverSocket = sf.createServerSocket(this.m_iBindingPort, 0, addr);
        if (this.m_serverSocket instanceof SSLServerSocket) {
            ((SSLServerSocket)this.m_serverSocket).setEnabledCipherSuites(((SSLServerSocket)this.m_serverSocket).getSupportedCipherSuites());
        }
        this.m_threadFactory = new ThreadFactory(this.m_iCommandExecutionTimeout, this.m_commandInvoker);
    }

    public void addAcceptedHosts(String sHost) throws UnknownHostException {
        InetAddress addr = InetAddress.getByName(sHost);
        this.m_vAcceptedHosts.add(addr);
    }

    public void run() {
        try {
            this.init();
            while (true) {
                Socket clientSocket;
                if (!this.canAccept((clientSocket = this.m_serverSocket.accept()).getInetAddress())) {
                    clientSocket.close();
                    continue;
                }
                JNRPEServerThread kk = this.m_threadFactory.createNewThread(clientSocket);
                kk.start();
            }
        }
        catch (SocketException se) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.exit();
    }

    private synchronized void exit() {
        this.notify();
    }

    public synchronized void close() {
        try {
            this.m_serverSocket.close();
            this.wait();
        }
        catch (InterruptedException ie) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean canAccept(InetAddress inetAddress) {
        for (InetAddress addr : this.m_vAcceptedHosts) {
            if (!addr.equals(inetAddress)) continue;
            return true;
        }
        System.out.println("Refusing connection to " + inetAddress);
        return false;
    }
}

