/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.proc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class StreamGobbler
extends Thread {
    private static final Logger LOG = Logger.getLogger(StreamGobbler.class);
    private static final int BUFFER_SIZE = 8192;
    private static final int CACHE_SIZE = 1024;
    private InputStream source;
    private OutputStream sink;
    private byte[] buffer;
    private int cache = 1024;
    private int len = 0;
    private boolean started = false;
    private Exception failCause;

    public StreamGobbler(InputStream in, OutputStream out) {
        if (in == null) {
            throw new NullPointerException("null InputStream");
        }
        this.source = in;
        this.sink = out;
        this.setDaemon(true);
    }

    public StreamGobbler(InputStream in) {
        this(in, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Cache size must be positive");
        }
        StreamGobbler streamGobbler = this;
        synchronized (streamGobbler) {
            if (this.started) {
                throw new IllegalStateException("StreamGobbler has started");
            }
            this.cache = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamGobbler streamGobbler = this;
        synchronized (streamGobbler) {
            if (this.started) {
                throw new IllegalThreadStateException("Run method has already been called");
            }
            this.started = true;
        }
        LOG.trace((Object)"StreamGobbler starting");
        this.buffer = new byte[8192 + this.cache];
        try {
            int n = 0;
            while (n >= 0 && !this.isInterrupted()) {
                StreamGobbler streamGobbler2 = this;
                synchronized (streamGobbler2) {
                    n = this.source.read(this.buffer, this.len, this.buffer.length - this.len);
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("read " + n));
                    }
                    if (n == -1) {
                        break;
                    }
                    if (this.sink != null) {
                        OutputStream outputStream = this.sink;
                        synchronized (outputStream) {
                            try {
                                this.sink.write(this.buffer, this.len, n);
                            }
                            catch (IOException e) {
                                LOG.error((Object)"Error writing to sink", (Throwable)e);
                                this.sink = null;
                                this.failCause = e;
                            }
                        }
                    }
                    if (this.cache > 0) {
                        this.len += n;
                        if (this.len >= this.cache) {
                            System.arraycopy(this.buffer, this.len - this.cache, this.buffer, 0, this.cache);
                            this.len = this.cache;
                        }
                    }
                }
                Thread.yield();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Error reading input", (Throwable)e);
            this.failCause = e;
        }
        if (this.isInterrupted()) {
            LOG.info((Object)"Interrupted: stopping");
        }
        if (this.sink != null) {
            try {
                this.sink.flush();
            }
            catch (IOException e) {
                LOG.error((Object)"Error flushing sink", (Throwable)e);
            }
        }
        LOG.trace((Object)"StreamGobbler finished");
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getCachedBytes() {
        if (!this.started) {
            throw new IllegalStateException("StreamGobbler not started");
        }
        StreamGobbler streamGobbler = this;
        synchronized (streamGobbler) {
            byte[] b = new byte[this.len];
            System.arraycopy(this.buffer, 0, b, 0, this.len);
            return b;
        }
    }

    public boolean isError() {
        return this.failCause != null;
    }

    public Exception getError() {
        return this.failCause;
    }
}

