/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.proc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sf.jnati.proc.ProcessOutput;
import net.sf.jnati.proc.StreamGobbler;
import net.sf.jnati.proc.TeeOutputStream;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessMonitor {
    private static final Logger LOG = Logger.getLogger(ProcessMonitor.class);
    private static final long STREAMGOBBLER_CLEANUP_TIMEOUT_MS = 500L;
    private static final int DEFAULT_TIMEOUT_MS = 60000;
    private ProcessBuilder builder;
    private Monitor runner;
    private long timeout = 60000L;
    private InputStream input;
    private OutputStream stdout;
    private OutputStream stderr;
    private ProcessState state = ProcessState.READY;
    private Integer exitValue;
    private ExecutionException ex;

    public ProcessMonitor(String ... command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.builder = new ProcessBuilder(command);
    }

    public ProcessMonitor(List<String> command) {
        if (command == null) {
            throw new NullPointerException();
        }
        ArrayList<String> copy = new ArrayList<String>(command);
        this.builder = new ProcessBuilder(copy);
    }

    public List<String> getCommand() {
        return new ArrayList<String>(this.builder.command());
    }

    public synchronized void setCommand(String ... command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.checkNotStarted();
        this.builder.command(command);
    }

    public synchronized void setCommand(List<String> command) {
        if (command == null) {
            throw new NullPointerException();
        }
        this.checkNotStarted();
        ArrayList<String> copy = new ArrayList<String>(command);
        this.builder = new ProcessBuilder(copy);
        this.builder.command(command);
    }

    public Map<String, String> getEnvironment() {
        return new HashMap<String, String>(this.builder.environment());
    }

    public synchronized void setEnvironmentVariable(String key, String value) {
        this.checkNotStarted();
        this.builder.environment().put(key, value);
    }

    public synchronized void unsetEnvironmentVariable(String key) {
        this.checkNotStarted();
        this.builder.environment().remove(key);
    }

    public File getWorkingDirectory() {
        return this.builder.directory();
    }

    public synchronized void setWorkingDirectory(File dir) {
        this.checkNotStarted();
        this.builder.directory(dir);
    }

    public void setInput(byte[] input) {
        this.setInput(input == null ? null : new ByteArrayInputStream(input));
    }

    public void setInput(String input) {
        this.setInput(input == null ? null : input.getBytes());
    }

    public synchronized void setInput(InputStream input) {
        this.checkNotStarted();
        this.input = input;
    }

    public synchronized void setErrorTarget(OutputStream stderr) {
        this.checkNotStarted();
        this.stderr = stderr;
    }

    public synchronized void setOutputTarget(OutputStream stdout) {
        this.checkNotStarted();
        this.stdout = stdout;
    }

    public synchronized void setRedirectErrorStream(boolean redirect) {
        this.checkNotStarted();
        this.builder.redirectErrorStream(redirect);
    }

    public boolean getRedirectErrorStream() {
        return this.builder.redirectErrorStream();
    }

    public synchronized void setTimeout(long timeout, TimeUnit timeoutUnit) {
        this.checkNotStarted();
        if (timeout < 0L) {
            throw new IllegalArgumentException("Negative time: " + timeout);
        }
        if (timeoutUnit == null) {
            throw new IllegalArgumentException("Null TimeUnit");
        }
        this.timeout = timeoutUnit.toMillis(timeout);
    }

    public long getTimeout(TimeUnit unit) {
        return unit.convert(this.timeout, TimeUnit.MILLISECONDS);
    }

    public Integer getExitValue() throws ExecutionException, TimeoutException {
        switch (this.state) {
            case READY: {
                throw new IllegalStateException("Not started");
            }
            case RUNNING: {
                throw new IllegalStateException("Running");
            }
            case TIMEDOUT: {
                throw new TimeoutException();
            }
            case CANCELLED: {
                throw new CancellationException();
            }
            case FAILED: {
                throw this.ex;
            }
            case FINISHED: {
                return this.exitValue;
            }
        }
        throw new RuntimeException("Unknown state: " + (Object)((Object)this.state));
    }

    public int execute() throws ExecutionException, InterruptedException, TimeoutException {
        this.start();
        int result = this.waitFor();
        return result;
    }

    public synchronized ProcessOutput runProcess() throws ExecutionException, InterruptedException, TimeoutException {
        this.checkNotStarted();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        if (this.stdout == null) {
            this.setOutputTarget(out);
        } else {
            this.setOutputTarget(new TeeOutputStream(this.stdout, out));
        }
        if (this.stderr == null) {
            this.setErrorTarget(err);
        } else {
            this.setErrorTarget(new TeeOutputStream(this.stderr, err));
        }
        int exitValue = this.execute();
        ProcessOutput result = new ProcessOutput();
        result.setExitValue(exitValue);
        result.setOutput(out.toByteArray());
        result.setError(err.toByteArray());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer waitFor() throws ExecutionException, TimeoutException, InterruptedException {
        ProcessMonitor processMonitor = this;
        synchronized (processMonitor) {
            if (this.state == ProcessState.READY) {
                throw new IllegalStateException("Not run");
            }
        }
        while (this.state == ProcessState.RUNNING) {
            this.runner.join();
            Thread.yield();
        }
        processMonitor = this;
        synchronized (processMonitor) {
            if (this.state == ProcessState.CANCELLED) {
                throw new CancellationException();
            }
            if (this.state == ProcessState.TIMEDOUT) {
                throw new TimeoutException();
            }
            if (this.state == ProcessState.FAILED) {
                throw this.ex;
            }
        }
        return this.exitValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        ProcessMonitor processMonitor = this;
        synchronized (processMonitor) {
            this.checkNotStarted();
            this.state = ProcessState.RUNNING;
        }
        this.runner = new Monitor(this.builder);
        new Thread("exec"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Executing command: " + ProcessMonitor.this.getCommand().get(0)));
                    }
                    long t0 = System.currentTimeMillis();
                    ProcessMonitor.this.runner.start();
                    ProcessMonitor.this.runner.join(ProcessMonitor.this.timeout);
                    long t1 = System.currentTimeMillis();
                    1 var5_4 = this;
                    synchronized (var5_4) {
                        if (ProcessMonitor.this.state == ProcessState.CANCELLED) {
                            throw new CancellationException();
                        }
                        if (ProcessMonitor.this.runner.isAlive()) {
                            LOG.warn((Object)("Timed-out: cancelling command (" + (t1 - t0) + "ms)"));
                            ProcessMonitor.this.state = ProcessState.TIMEDOUT;
                            ProcessMonitor.this.runner.interrupt();
                            throw new TimeoutException();
                        }
                        if (ProcessMonitor.this.runner.ex != null) {
                            ProcessMonitor.this.state = ProcessState.FAILED;
                            ProcessMonitor.this.ex = new ExecutionException(ProcessMonitor.this.runner.ex);
                            throw ProcessMonitor.this.ex;
                        }
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("Command complete (" + (t1 - t0) + "ms)"));
                        }
                        ProcessMonitor.this.exitValue = ProcessMonitor.this.runner.exitValue;
                        ProcessMonitor.this.state = ProcessState.FINISHED;
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)"Error", (Throwable)e);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ProcessMonitor processMonitor = this;
        synchronized (processMonitor) {
            if (this.state == ProcessState.READY) {
                throw new IllegalStateException("Not started");
            }
            if (this.state == ProcessState.RUNNING) {
                LOG.info((Object)"Cancelling command");
                this.state = ProcessState.CANCELLED;
                this.runner.interrupt();
            }
        }
    }

    public byte[] getCachedOutput() {
        if (this.state == ProcessState.READY) {
            throw new IllegalStateException("Not started");
        }
        return this.runner.gobbleIn.getCachedBytes();
    }

    public byte[] getCachedError() {
        if (this.state == ProcessState.READY) {
            throw new IllegalStateException("Not started");
        }
        return this.runner.gobbleErr.getCachedBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotStarted() {
        ProcessMonitor processMonitor = this;
        synchronized (processMonitor) {
            if (this.state != ProcessState.READY) {
                throw new IllegalStateException("Process started");
            }
        }
    }

    public ProcessState getState() {
        return this.state;
    }

    public Throwable getFailCause() {
        return this.ex == null ? null : this.ex.getCause();
    }

    private class Monitor
    extends Thread {
        private final ProcessBuilder processBuilder;
        private StreamGobbler gobbleIn;
        private StreamGobbler gobbleErr;
        private Integer exitValue;
        private Exception ex;

        public Monitor(ProcessBuilder builder) {
            super("pmon");
            this.processBuilder = builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                LOG.debug((Object)"Starting process");
                Process process = this.processBuilder.start();
                LOG.debug((Object)"Staring StreamGobblers");
                this.gobbleIn = new StreamGobbler(process.getInputStream(), ProcessMonitor.this.stdout);
                this.gobbleIn.setName("sg.in");
                this.gobbleErr = new StreamGobbler(process.getErrorStream(), ProcessMonitor.this.stderr);
                this.gobbleErr.setName("sg.err");
                this.gobbleIn.start();
                this.gobbleErr.start();
                try {
                    try {
                        LOG.debug((Object)"Waiting for StreamGobblers");
                        while (!this.gobbleIn.isStarted() || !this.gobbleErr.isStarted()) {
                            Thread.yield();
                        }
                        LOG.debug((Object)"Sending input");
                        OutputStream out = process.getOutputStream();
                        try {
                            if (ProcessMonitor.this.input != null) {
                                try {
                                    byte[] b = new byte[8192];
                                    int n = ProcessMonitor.this.input.read(b);
                                    while (n != -1) {
                                        if (LOG.isTraceEnabled()) {
                                            LOG.trace((Object)("sent: " + n + " bytes"));
                                        }
                                        out.write(b, 0, n);
                                        n = ProcessMonitor.this.input.read(b);
                                    }
                                    Object var6_9 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var6_10 = null;
                                    ProcessMonitor.this.input.close();
                                    throw throwable;
                                }
                                ProcessMonitor.this.input.close();
                            }
                            Object var8_12 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_13 = null;
                            out.close();
                            throw throwable;
                        }
                        out.close();
                        LOG.debug((Object)"Waiting for process");
                        process.waitFor();
                        LOG.debug((Object)"Process finished");
                        this.gobbleIn.join();
                        this.gobbleErr.join();
                        LOG.debug((Object)"StreamGobblers finished");
                        int exitValue = process.exitValue();
                        LOG.trace((Object)("Exit value: " + exitValue));
                        this.exitValue = exitValue;
                    }
                    catch (InterruptedException e) {
                        LOG.info((Object)"Interrupted: destroying process");
                        process.destroy();
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Exception occured - destroying process", (Throwable)e);
                        process.destroy();
                        throw e;
                    }
                    Object var10_15 = null;
                    process.destroy();
                }
                catch (Throwable throwable) {
                    Object var10_16 = null;
                    process.destroy();
                    if (!this.gobbleIn.isAlive()) {
                        if (!this.gobbleErr.isAlive()) throw throwable;
                    }
                    LOG.trace((Object)"Cleaning up StreamGobblers");
                    if (this.gobbleIn.isAlive()) {
                        this.gobbleIn.interrupt();
                    }
                    if (this.gobbleErr.isAlive()) {
                        this.gobbleErr.interrupt();
                    }
                    long t0 = System.currentTimeMillis() + 500L;
                    while ((this.gobbleIn.isAlive() || this.gobbleErr.isAlive()) && System.currentTimeMillis() < t0) {
                        Thread.yield();
                    }
                    if (!this.gobbleIn.isAlive()) {
                        if (!this.gobbleErr.isAlive()) throw throwable;
                    }
                    LOG.error((Object)"StreamGobblers failed to terminate");
                    throw throwable;
                }
                if (!this.gobbleIn.isAlive()) {
                    if (!this.gobbleErr.isAlive()) return;
                }
                LOG.trace((Object)"Cleaning up StreamGobblers");
                if (this.gobbleIn.isAlive()) {
                    this.gobbleIn.interrupt();
                }
                if (this.gobbleErr.isAlive()) {
                    this.gobbleErr.interrupt();
                }
                long t0 = System.currentTimeMillis() + 500L;
                while ((this.gobbleIn.isAlive() || this.gobbleErr.isAlive()) && System.currentTimeMillis() < t0) {
                    Thread.yield();
                }
                if (!this.gobbleIn.isAlive()) {
                    if (!this.gobbleErr.isAlive()) return;
                }
                LOG.error((Object)"StreamGobblers failed to terminate");
                return;
            }
            catch (Exception e) {
                this.ex = e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProcessState {
        READY,
        RUNNING,
        FINISHED,
        CANCELLED,
        TIMEDOUT,
        FAILED;

    }
}

