/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.parser;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ParameterParser {
    private static final String REGEX_HASH_SYMBOL = "#\\{[\\w]+\\}";
    private static final String REGEX_TWODOTS_SYMBOL = ":[\\w]+";
    private static final String REGEX_QUESTION_SYMBOL = "\\?";
    public static final Pattern patternHash = Pattern.compile("#\\{[\\w]+\\}", 2);
    public static final Pattern patternTowDots = Pattern.compile(":[\\w]+", 2);
    public static final Pattern patternQuestion = Pattern.compile("\\?", 2);

    private ParameterParser() {
    }

    public static String[] extract(String sentence) {
        if (sentence == null) {
            return new String[0];
        }
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcherHash = patternHash.matcher(sentence);
        Matcher matcherTwoDots = patternTowDots.matcher(sentence);
        Matcher matcherQuestion = patternQuestion.matcher(sentence);
        boolean findPlaceHoldMarker = false;
        int i = 0;
        while (matcherHash.find()) {
            params.add(i, sentence.subSequence(matcherHash.start() + 2, matcherHash.end() - 1).toString());
            ++i;
            findPlaceHoldMarker = true;
        }
        while (matcherTwoDots.find()) {
            if (findPlaceHoldMarker && !params.isEmpty()) {
                throw new RuntimeException("Cannot mix parameters placehold '#{param}', ':param' and '?' symbol, use just one don't mix. The symbol at position: " + matcherQuestion.start() + " from [" + sentence + "] is invalid!");
            }
            params.add(i, sentence.subSequence(matcherTwoDots.start() + 1, matcherTwoDots.end()).toString());
            ++i;
        }
        boolean bl = findPlaceHoldMarker = !params.isEmpty();
        while (matcherQuestion.find()) {
            if (findPlaceHoldMarker && !params.isEmpty()) {
                throw new RuntimeException("Cannot mix parameters placehold '#{param}', ':param' and '?' symbol, use just one don't mix. The symbol at position: " + matcherQuestion.start() + " from [" + sentence + "] is invalid!");
            }
            params.add(i, sentence.subSequence(matcherQuestion.start(), matcherQuestion.end()).toString());
            ++i;
        }
        return params.toArray(new String[0]);
    }
}

