/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder.xml;

import net.sf.jkniv.sqlegance.builder.ConfigurationException;
import net.sf.jkniv.sqlegance.builder.xml.ParameterMode;

public class ProcedureParameterTag {
    public static final String TAG_NAME = "parameter";
    public static final String ATTRIBUTE_PROPERTY = "property";
    public static final String ATTRIBUTE_MODE = "mode";
    public static final String ATTRIBUTE_SQLTYPE = "sqlType";
    public static final String ATTRIBUTE_TYPENAME = "typeName";
    private int sqlType;
    private String typeName;
    private String property;
    private ParameterMode mode;

    public ProcedureParameterTag(String property, String mode, String sqlType, String typeName) {
        this.property = property;
        this.sqlType = this.getSqlType(sqlType);
        this.mode = this.getParameterMode(mode);
        this.typeName = typeName;
    }

    public ProcedureParameterTag(String property, String mode, String sqlType) {
        this(property, mode, sqlType, null);
    }

    public ProcedureParameterTag(String property, String mode) {
        this(property, mode, "NULL", null);
    }

    private ParameterMode getParameterMode(String mode) {
        ParameterMode pmode = ParameterMode.IN;
        for (ParameterMode m : ParameterMode.values()) {
            if (!m.toString().equalsIgnoreCase(mode)) continue;
            pmode = m;
        }
        return pmode;
    }

    private int getSqlType(String sqlType) {
        int type = 12;
        if ("ARRAY".equalsIgnoreCase(sqlType)) {
            type = 2003;
        } else if ("BOOLEAN".equalsIgnoreCase(sqlType)) {
            type = 16;
        } else if ("VARCHAR".equalsIgnoreCase(sqlType)) {
            type = 12;
        } else if ("CHAR".equalsIgnoreCase(sqlType)) {
            type = 1;
        } else if ("NCHAR".equalsIgnoreCase(sqlType)) {
            type = -15;
        } else if ("DATE".equalsIgnoreCase(sqlType)) {
            type = 91;
        } else if ("TIME".equalsIgnoreCase(sqlType)) {
            type = 92;
        } else if ("TIMESTAMP".equalsIgnoreCase(sqlType)) {
            type = 93;
        } else if ("DOUBLE".equalsIgnoreCase(sqlType)) {
            type = 8;
        } else if ("FLOAT".equalsIgnoreCase(sqlType)) {
            type = 6;
        } else if ("INTEGER".equalsIgnoreCase(sqlType)) {
            type = 4;
        } else if ("BIGINT".equalsIgnoreCase(sqlType)) {
            type = -5;
        } else if ("SMALLINT".equalsIgnoreCase(sqlType)) {
            type = 5;
        } else if ("REAL".equalsIgnoreCase(sqlType)) {
            type = 7;
        } else if ("DECIMAL".equalsIgnoreCase(sqlType)) {
            type = 3;
        } else if ("TINYINT".equalsIgnoreCase(sqlType)) {
            type = -6;
        } else if ("LONGNVARCHAR".equalsIgnoreCase(sqlType)) {
            type = -16;
        } else if ("LONGVARBINARY".equalsIgnoreCase(sqlType)) {
            type = -4;
        } else if ("LONGVARCHAR".equalsIgnoreCase(sqlType)) {
            type = -1;
        } else if ("BINARY".equalsIgnoreCase(sqlType)) {
            type = -2;
        } else if ("BIT".equalsIgnoreCase(sqlType)) {
            type = -7;
        } else if ("BLOB".equalsIgnoreCase(sqlType)) {
            type = 2004;
        } else if ("CLOB".equalsIgnoreCase(sqlType)) {
            type = 2005;
        } else if ("DATALINK".equalsIgnoreCase(sqlType)) {
            type = 70;
        } else if ("DISTINCT".equalsIgnoreCase(sqlType)) {
            type = 2001;
        } else if ("JAVA_OBJECT".equalsIgnoreCase(sqlType)) {
            type = 2000;
        } else if ("NCLOB".equalsIgnoreCase(sqlType)) {
            type = 2011;
        } else if ("NUMERIC".equalsIgnoreCase(sqlType)) {
            type = 2;
        } else if ("OTHER".equalsIgnoreCase(sqlType)) {
            type = 1111;
        } else if ("REF".equalsIgnoreCase(sqlType)) {
            type = 2006;
        } else if ("ROWID".equalsIgnoreCase(sqlType)) {
            type = -8;
        } else if ("SQLXML".equalsIgnoreCase(sqlType)) {
            type = 2009;
        } else if ("STRUCT".equalsIgnoreCase(sqlType)) {
            type = 2002;
        } else if ("VARBINARY".equalsIgnoreCase(sqlType)) {
            type = -3;
        } else if ("NULL".equalsIgnoreCase(sqlType)) {
            type = 0;
        } else {
            throw new ConfigurationException("Cannot identify the sql type at procedure parameter, check the posible values at java.sql.Types.");
        }
        return type;
    }

    public String getTagName() {
        return TAG_NAME;
    }

    public String getProperty() {
        return this.property;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public ParameterMode getMode() {
        return this.mode;
    }

    public String getTypeName() {
        return this.typeName;
    }
}

