/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder.xml;

import java.util.ArrayList;
import java.util.List;
import net.sf.jkniv.sqlegance.builder.xml.ISqlTag;
import net.sf.jkniv.sqlegance.builder.xml.LanguageType;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.ITextTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.StaticText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSqlTag
implements ISqlTag {
    public final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String ATTRIBUTE_NAME = "id";
    public static final String ATTRIBUTE_TYPE = "type";
    protected String id;
    protected LanguageType languageType;
    private List<ITextTag> textTag = new ArrayList<ITextTag>();

    public AbstractSqlTag(String id, LanguageType languageType) {
        this.id = id;
        this.languageType = languageType;
    }

    @Override
    public String getSql() {
        StringBuilder sb = new StringBuilder();
        for (ITextTag text : this.textTag) {
            if (text.isDynamic()) continue;
            if (sb.length() > 0) {
                sb.append(" " + text.getText());
                continue;
            }
            sb.append(text.getText());
        }
        return sb.toString();
    }

    @Override
    public String getSql(Object params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.textTag.size(); ++i) {
            ITextTag tag = this.textTag.get(i);
            boolean result = tag.eval(params);
            this.log.trace("eval [" + result + "] " + tag.getText());
            if (!result) continue;
            if (sb.length() > 0) {
                sb.append(" " + tag.getText());
                continue;
            }
            sb.append(tag.getText());
        }
        return sb.toString();
    }

    @Override
    public LanguageType getLanguageType() {
        return this.languageType;
    }

    @Override
    public String getName() {
        return this.id;
    }

    @Override
    public void addTag(ITextTag tag) {
        this.textTag.add(tag);
    }

    @Override
    public void addTag(String text) {
        this.textTag.add(new StaticText(text));
    }

    @Override
    public void addTag(List<ITextTag> tags) {
        this.textTag.addAll(tags);
    }
}

