/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jkniv.sqlegance.builder;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.jkniv.sqlegance.builder.ConfigurationException;
import net.sf.jkniv.sqlegance.builder.SqlFile;
import net.sf.jkniv.sqlegance.builder.xml.AbstractSqlTag;
import net.sf.jkniv.sqlegance.builder.xml.DeleteTag;
import net.sf.jkniv.sqlegance.builder.xml.ISql;
import net.sf.jkniv.sqlegance.builder.xml.ISqlTag;
import net.sf.jkniv.sqlegance.builder.xml.InsertTag;
import net.sf.jkniv.sqlegance.builder.xml.LanguageType;
import net.sf.jkniv.sqlegance.builder.xml.ProcedureParameterTag;
import net.sf.jkniv.sqlegance.builder.xml.ProcedureTag;
import net.sf.jkniv.sqlegance.builder.xml.SelectTag;
import net.sf.jkniv.sqlegance.builder.xml.UpdateTag;
import net.sf.jkniv.sqlegance.builder.xml.XMLFileStatus;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.ChooseTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.ITextTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.IfTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.OtherwiseTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.SetTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.StaticText;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.WhenTag;
import net.sf.jkniv.sqlegance.builder.xml.dynamic.WhereTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlBuilderSql {
    private static final Logger log = LoggerFactory.getLogger(XmlBuilderSql.class);
    private static final Map<String, ISql> map = new HashMap<String, ISql>();
    private static String defaultFileConfig = "/SqlConfig.xml";
    private static boolean initialized = false;
    private static List<SqlFile> listFile = new ArrayList<SqlFile>();
    private static XPath xpath = XPathFactory.newInstance().newXPath();
    private static final String ROOT_NODE = "statements/";
    private static final String ROOT_NODE_PACKAGE = "statements/package";

    private XmlBuilderSql() {
    }

    private static void init() {
        InputStream is;
        if (!initialized && (is = XmlBuilderSql.class.getResourceAsStream(defaultFileConfig)) != null) {
            Document doc = XmlBuilderSql.loadXML(is);
            NodeList filesInc = doc.getElementsByTagName("include");
            if (filesInc != null) {
                for (int i = 0; i < filesInc.getLength(); ++i) {
                    Element e = (Element)filesInc.item(i);
                    SqlFile f = new SqlFile(e.getAttribute("href"));
                    listFile.add(f);
                    Document docInclude = XmlBuilderSql.loadXML(XmlBuilderSql.class.getResourceAsStream(f.getName()));
                    XmlBuilderSql.processXML(docInclude, f);
                }
            }
            SqlFile f = new SqlFile(defaultFileConfig);
            XmlBuilderSql.processTagElements(doc, f);
            initialized = true;
        }
    }

    public static ISql getQuery(String name) {
        ISql sql = null;
        if (!initialized) {
            try {
                XmlBuilderSql.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!map.containsKey(name)) {
            throw new IllegalArgumentException("Query not found [" + name + "]");
        }
        sql = map.get(name);
        return sql;
    }

    public static boolean containsQuery(String name) {
        return map.containsKey(name);
    }

    public static void configFile(String fileConfig) {
        defaultFileConfig = fileConfig;
        initialized = false;
        listFile.clear();
        map.clear();
        XmlBuilderSql.init();
    }

    private static Document loadXML(InputStream xml) {
        Document doc = null;
        if (xml == null) {
            throw new ConfigurationException("There is XML file '<include href=...' that is not correctly named, check the name from your xml files at '<include href=...' tag. The file path is absolute and must agree that package is.");
        }
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            doc = docBuilder.parse(xml);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error in parser the xml file [" + xml + "]. ParserConfigurationException: " + e.getMessage() + ". Verify if the name from file start with '/' and contains the package, because the path is absolute");
        }
        catch (SAXException e) {
            throw new RuntimeException("Error in parser the xml file [" + xml + "]. SAXException: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException("Error in parser the xml file [" + xml + "]. IOException: " + e.getMessage());
        }
        return doc;
    }

    private static void processXML(Document doc, SqlFile file) {
        log.trace("process xml " + file);
        if (file.getStatus() == XMLFileStatus.PROCESSED) {
            return;
        }
        file.processed();
        doc.getDocumentElement().normalize();
        NodeList filesInc = doc.getElementsByTagName("include");
        if (filesInc != null) {
            for (int i = 0; i < filesInc.getLength(); ++i) {
                Element e = (Element)filesInc.item(i);
                SqlFile fileIncluded = new SqlFile(e.getAttribute("href"));
                listFile.add(fileIncluded);
                Document docInclude = XmlBuilderSql.loadXML(XmlBuilderSql.class.getResourceAsStream(fileIncluded.getName()));
                XmlBuilderSql.processXML(docInclude, fileIncluded);
            }
        }
        XmlBuilderSql.processTagElements(doc, file);
    }

    private static void processTagElements(Document doc, SqlFile f) {
        XmlBuilderSql.processTagsElements(XmlBuilderSql.evaluateXPATH("statements/select", doc), f.getName(), "");
        XmlBuilderSql.processTagsElements(XmlBuilderSql.evaluateXPATH("statements/insert", doc), f.getName(), "");
        XmlBuilderSql.processTagsElements(XmlBuilderSql.evaluateXPATH("statements/update", doc), f.getName(), "");
        XmlBuilderSql.processTagsElements(XmlBuilderSql.evaluateXPATH("statements/delete", doc), f.getName(), "");
        XmlBuilderSql.processProcedureElements(XmlBuilderSql.evaluateXPATH("statements/procedure", doc), f.getName(), "");
        NodeList nodes = XmlBuilderSql.evaluateXPATH(ROOT_NODE_PACKAGE, doc);
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String name = element.getAttribute("name");
                XmlBuilderSql.processTagsElements(XmlBuilderSql.evaluateXPATH("select", element), f.getName(), name);
                XmlBuilderSql.processTagsElements(XmlBuilderSql.evaluateXPATH("insert", element), f.getName(), name);
                XmlBuilderSql.processTagsElements(XmlBuilderSql.evaluateXPATH("update", element), f.getName(), name);
                XmlBuilderSql.processTagsElements(XmlBuilderSql.evaluateXPATH("delete", element), f.getName(), name);
                XmlBuilderSql.processProcedureElements(XmlBuilderSql.evaluateXPATH("procedure", element), f.getName(), name);
            }
        }
    }

    private static void processTagsElements(NodeList nodes, String fileName, String packet) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String id = element.getAttribute("id");
            LanguageType type = XmlBuilderSql.getLanguageType(element.getAttribute("type"));
            ISqlTag tag = XmlBuilderSql.getTag(node.getNodeName(), id, type);
            for (int j = 0; j < element.getChildNodes().getLength(); ++j) {
                ITextTag textTag = XmlBuilderSql.getDynamicNode(element.getChildNodes().item(j));
                if (textTag == null) continue;
                tag.addTag(textTag);
            }
            if (packet == null || "".equals(packet)) {
                XmlBuilderSql.putSql(id, node.getNodeName(), fileName, tag);
                continue;
            }
            XmlBuilderSql.putSql(packet + "." + id, node.getNodeName(), fileName, tag);
        }
    }

    private static ITextTag getDynamicNode(Node node) {
        String nodeName = node.getNodeName();
        String text = node.getNodeValue();
        ITextTag tag = null;
        if ("if".equals(nodeName)) {
            Element element = (Element)node;
            tag = new IfTag(element.getAttribute("test"), XmlBuilderSql.getTextFromElement(element));
        } else if ("where".equals(nodeName)) {
            Element element = (Element)node;
            List<ITextTag> listIfTag = XmlBuilderSql.processTagDecision(element);
            tag = new WhereTag(listIfTag);
        } else if ("set".equals(nodeName)) {
            Element element = (Element)node;
            List<ITextTag> listIfTag = XmlBuilderSql.processTagDecision(element);
            tag = new SetTag(listIfTag);
        } else if ("choose".equals(nodeName)) {
            Element element = (Element)node;
            List<WhenTag> listWhenTag = XmlBuilderSql.processWhenTag(element);
            tag = new ChooseTag(listWhenTag);
        } else if (text != null && !"".equals(text = text.trim())) {
            tag = new StaticText(text);
        }
        return tag;
    }

    private static ISqlTag getTag(String nodeName, String id, LanguageType type) {
        AbstractSqlTag tag = null;
        if ("select".equals(nodeName)) {
            tag = new SelectTag(id, type);
        } else if ("insert".equals(nodeName)) {
            tag = new InsertTag(id, type);
        } else if ("update".equals(nodeName)) {
            tag = new UpdateTag(id, type);
        } else if ("delete".equals(nodeName)) {
            tag = new DeleteTag(id, type);
        } else if ("procedure".equals(nodeName)) {
            tag = new ProcedureTag(id, type);
        }
        return tag;
    }

    private static void processProcedureElements(NodeList procedures, String fileName, String packet) {
        for (int s = 0; s < procedures.getLength(); ++s) {
            Node firstNode = procedures.item(s);
            if (firstNode.getNodeType() != 1) continue;
            Element element = (Element)firstNode;
            String id = element.getAttribute("id");
            String spName = element.getAttribute("spname");
            ProcedureTag tag = new ProcedureTag(id, LanguageType.STORED);
            tag.setSpName(spName);
            ProcedureParameterTag[] paramsTag = XmlBuilderSql.processParameterTag(element);
            tag.setParams(paramsTag);
            XmlBuilderSql.putSql(id, "procedure", fileName, tag);
        }
    }

    private static List<ITextTag> processTagDecision(Element element) {
        ArrayList<ITextTag> list = new ArrayList<ITextTag>();
        NodeList nodeList = XmlBuilderSql.evaluateXPATH("if | choose", element);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element elementNode = (Element)nodeList.item(i);
            if ("if".equalsIgnoreCase(elementNode.getTagName())) {
                IfTag tag = new IfTag(elementNode.getAttribute("test"), XmlBuilderSql.getTextFromElement(elementNode));
                list.add(i, tag);
                continue;
            }
            if (!"choose".equalsIgnoreCase(elementNode.getTagName())) continue;
            List<WhenTag> listWhen = XmlBuilderSql.processWhenTag(elementNode);
            list.add(new ChooseTag(listWhen));
        }
        return list;
    }

    private static List<WhenTag> processWhenTag(Element element) {
        WhenTag tag;
        int i;
        ArrayList<WhenTag> list = new ArrayList<WhenTag>();
        NodeList nodeList = XmlBuilderSql.evaluateXPATH("when", element);
        for (i = 0; i < nodeList.getLength(); ++i) {
            Element whnEle = (Element)nodeList.item(i);
            tag = new WhenTag(whnEle.getAttribute("test"), XmlBuilderSql.getTextFromElement(whnEle));
            list.add(i, tag);
        }
        nodeList = XmlBuilderSql.evaluateXPATH("otherwise", element);
        for (i = 0; i < nodeList.getLength(); ++i) {
            Element otherEle = (Element)nodeList.item(i);
            tag = new OtherwiseTag(XmlBuilderSql.getTextFromElement(otherEle));
            list.add(tag);
            if (i <= 0) continue;
            throw new ConfigurationException("There are more one <otherwise> tag inner <choose> tag");
        }
        return list;
    }

    private static ProcedureParameterTag[] processParameterTag(Element element) {
        NodeList nodeList = XmlBuilderSql.evaluateXPATH("parameter", element);
        ProcedureParameterTag[] params = new ProcedureParameterTag[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ProcedureParameterTag tag = null;
            Element ele = (Element)nodeList.item(i);
            String property = ele.getAttribute("property");
            String mode = ele.getAttribute("mode");
            String sqlType = ele.getAttribute("sqlType");
            String typeName = ele.getAttribute("typeName");
            if (!"".equals(typeName) && "IN".equals(mode)) {
                throw new ConfigurationException("The parameter [" + property + "] is wrong. There is a typeName [" + typeName + "] but is like IN mode. TypeName must be used with OUT or INOUT");
            }
            if (!"".equals(typeName) && "".equals(sqlType)) {
                throw new ConfigurationException("The parameter [" + property + "] is wrong. There is a typeName [" + typeName + "] but dont have a sqlType defined");
            }
            tag = "".equals(sqlType) && "".equals(typeName) ? new ProcedureParameterTag(property, mode) : (!"".equals(typeName) && "".equals(typeName) ? new ProcedureParameterTag(property, mode, sqlType) : new ProcedureParameterTag(property, mode, sqlType, typeName));
            params[i] = tag;
        }
        return params;
    }

    private static NodeList evaluateXPATH(String expressionXpath, Element element) {
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xpath.evaluate(expressionXpath, element, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            log.info("XPath is wrong: " + expressionXpath);
        }
        return nodeList;
    }

    private static NodeList evaluateXPATH(String expressionXpath, Document doc) {
        NodeList nodeList = null;
        try {
            XPathExpression exp = xpath.compile(expressionXpath);
            nodeList = (NodeList)exp.evaluate(doc, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            log.info("XPath is wrong: " + expressionXpath);
        }
        return nodeList;
    }

    private static String getTextFromElement(Element element) {
        String text = element.getChildNodes().item(0).getNodeValue().trim();
        if ((text == null || "".equals(text)) && element.getChildNodes().item(0).getNextSibling() != null) {
            text = element.getChildNodes().item(0).getNextSibling().getNodeValue().trim();
        }
        return text;
    }

    private static LanguageType getLanguageType(String type) {
        LanguageType t = null;
        for (LanguageType qt : LanguageType.values()) {
            if (!String.valueOf(type).equalsIgnoreCase(qt.toString())) continue;
            t = qt;
            break;
        }
        if (t == null) {
            t = LanguageType.JPQL;
            System.err.println("Type [" + type + "] query no defined (JPQL, HQL, NATIVE, STORED), default JPQL");
        }
        return t;
    }

    private static void putSql(String name, String tagName, String fileName, ISql tag) {
        if (map.containsKey(name)) {
            throw new IllegalArgumentException("Query with name <" + tagName + " name=\"" + name + "\"... is duplicated at file [" + fileName + "]");
        }
        map.put(name, tag);
    }

    public static List<SqlFile> getFiles() {
        return Collections.unmodifiableList(listFile);
    }

    private static void copyWhen(List<ITextTag> destiny, List<WhenTag> source) {
        for (int i = 0; i < source.size(); ++i) {
            ITextTag t = source.get(i);
            destiny.add(t);
        }
    }

    private static void copyChoose(List<ITextTag> destiny, List<ChooseTag> source) {
        for (int i = 0; i < source.size(); ++i) {
            ITextTag t = source.get(i);
            destiny.add(t);
        }
    }
}

