/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0 Unless required by
 * applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS
 * OF ANY KIND, either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package net.sf.jkniv.sqlegance.builder.xml.dynamic;

/**
 * This class represent text found at NodeValue from tag at XML document. Sample
 * 
 * <pre>
 *     &lt;update id="updateAuthor2" type="NATIVE"&gt;
 *       update Author
 *       &lt;set&gt;
 *         &lt;if test="username != null"&gt;username = #{username},&lt;/if&gt;
 *         &lt;if test="password != null"&gt;password = #{password},&lt;/if&gt;
 *         &lt;if test="email != null"&gt;email = #{email},&lt;/if&gt;
 *         &lt;if test="bio != null"&gt;bio = #{bio},&lt;/if&gt;
 *       &lt;/set&gt;
 *       where id=#{id}
 *   &lt;/update&gt;
 * </pre>
 * 
 * Here we have two StaticText objects:
 * 
 * <pre>
 * update Author
 * </pre>
 * 
 * and
 * 
 * <pre>
 * where id=#{id}
 * </pre>
 * 
 * @author alisson gomes
 */
public class StaticText implements ITextTag
{
    private String text;
    
    /**
     * build static text object.
     * 
     * @param text
     *            static
     */
    public StaticText(String text)
    {
        this.text = text;
    }
    
    /**
     * Evaluate if attribute test is true.
     * 
     * @return always true, this is static text.
     */
    public boolean eval(Object rootObjects)
    {
        return true;
    }
    
    /**
     * Retrieve the text from XML element.
     * 
     * @return text from XML element.
     */
    public String getText()
    {
        return this.text;
    }
    
    /**
     * Indicate if text is dynamic or static.
     * 
     * @return always false is returned, because this object save static text.
     */
    public boolean isDynamic()
    {
        return false;
    }
    
}
